/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.persistence;

import me.testaccount666.serversystem.userdata.persistence.FieldHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class LocationFieldHandler
implements FieldHandler<Location> {
    @Override
    public void save(FileConfiguration config, String path, Location location) {
        if (location == null) {
            config.set(path, null);
            return;
        }
        if (!location.isWorldLoaded()) {
            return;
        }
        config.set(path + ".World", (Object)location.getWorld().getName());
        config.set(path + ".X", (Object)location.getX());
        config.set(path + ".Y", (Object)location.getY());
        config.set(path + ".Z", (Object)location.getZ());
        config.set(path + ".Yaw", (Object)Float.valueOf(location.getYaw()));
        config.set(path + ".Pitch", (Object)Float.valueOf(location.getPitch()));
    }

    @Override
    public Location load(FileConfiguration config, String path, Location defaultValue) {
        if (!config.isSet(path)) {
            return defaultValue;
        }
        String worldName = config.getString(path + ".World", "");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return defaultValue;
        }
        double x = config.getDouble(path + ".X");
        double y = config.getDouble(path + ".Y");
        double z = config.getDouble(path + ".Z");
        float yaw = (float)config.getDouble(path + ".Yaw");
        float pitch = (float)config.getDouble(path + ".Pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }
}

