/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public final class ComponentColor {
    private static final Logger _LOGGER = Logger.getLogger(ComponentColor.class.getName());
    private static final Map<Character, NamedTextColor> _COLOR_MAP = new HashMap<Character, NamedTextColor>();
    private static final Map<Character, TextDecoration> _DECORATION_MAP = new HashMap<Character, TextDecoration>();
    private static final Map<NamedTextColor, Character> _REVERSE_COLOR_MAP = new HashMap<NamedTextColor, Character>();
    private static final Map<TextDecoration, Character> _REVERSE_DECORATION_MAP = new HashMap<TextDecoration, Character>();

    private ComponentColor() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static Component translateToComponent(String text) {
        return ComponentColor.translateAlternateColorCodesToComponent('&', text);
    }

    public static Component translateAlternateColorCodesToComponent(char altColorChar, String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        return ComponentColor.parseColoredText(altColorChar, text);
    }

    public static Component coloredHex(String text, String hexCode) {
        if (text == null) {
            text = "";
        }
        if (hexCode == null) {
            hexCode = "";
        }
        if (((String)hexCode).isEmpty()) {
            return Component.empty();
        }
        if (!((String)hexCode).startsWith("#")) {
            hexCode = "#" + (String)hexCode;
        }
        if (((String)hexCode).length() < 7) {
            return Component.text((String)text);
        }
        try {
            TextColor color = TextColor.fromHexString((String)hexCode);
            return Component.text((String)text).color(color);
        }
        catch (IllegalArgumentException exception) {
            _LOGGER.log(Level.WARNING, "Invalid hex color code: " + (String)hexCode, exception);
            return Component.text((String)text);
        }
    }

    private static Component parseColoredText(char altColorChar, String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        if (!text.contains(String.valueOf(altColorChar))) {
            return Component.text((String)text);
        }
        String[] textParts = text.split(String.valueOf(altColorChar));
        TextComponent.Builder componentBuilder = Component.text();
        if (textParts.length > 0) {
            componentBuilder.append((Component)Component.text((String)textParts[0]));
        }
        if (textParts.length <= 1) {
            return componentBuilder.build();
        }
        FormatState formatState = new FormatState();
        for (int index = 1; index < textParts.length; ++index) {
            Component partComponent = ComponentColor.processTextPart(altColorChar, textParts[index], formatState);
            componentBuilder.append(partComponent);
        }
        return componentBuilder.build();
    }

    private static Component processTextPart(char altColorChar, String textPart, FormatState formatState) {
        if (textPart.isEmpty()) {
            return Component.text((String)String.valueOf(altColorChar));
        }
        char formatCode = textPart.charAt(0);
        if (formatCode == '#' && textPart.length() >= 7) {
            return ComponentColor.processHexColorCode(altColorChar, textPart, formatState);
        }
        if (_COLOR_MAP.containsKey(Character.valueOf(formatCode = Character.toLowerCase(formatCode)))) {
            return ComponentColor.processStandardColorCode(formatCode, textPart, formatState);
        }
        if (_DECORATION_MAP.containsKey(Character.valueOf(formatCode))) {
            return ComponentColor.processDecorationCode(formatCode, textPart, formatState);
        }
        if (formatCode == 'r') {
            return ComponentColor.processResetCode(textPart, formatState);
        }
        return Component.text((String)(altColorChar + textPart));
    }

    private static Component processHexColorCode(char altColorChar, String textPart, FormatState formatState) {
        String hexCode = textPart.substring(0, 7);
        String remainingText = textPart.substring(7);
        try {
            formatState.currentColor = TextColor.fromHexString((String)hexCode);
            formatState.activeDecorations.clear();
            return ComponentColor.coloredHex(remainingText, hexCode);
        }
        catch (IllegalArgumentException ignored) {
            return Component.text((String)(altColorChar + textPart));
        }
    }

    private static Component processStandardColorCode(char colorCode, String textPart, FormatState formatState) {
        formatState.currentColor = (TextColor)_COLOR_MAP.get(Character.valueOf(colorCode));
        formatState.activeDecorations.clear();
        return Component.text((String)textPart.substring(1)).color(formatState.currentColor);
    }

    private static Component processDecorationCode(char decorationCode, String textPart, FormatState formatState) {
        TextDecoration decoration = _DECORATION_MAP.get(Character.valueOf(decorationCode));
        formatState.activeDecorations.add(decoration);
        TextComponent component = (TextComponent)Component.text((String)textPart.substring(1)).decoration(decoration, true);
        for (TextDecoration activeDecoration : formatState.activeDecorations) {
            component = (TextComponent)component.decoration(activeDecoration, true);
        }
        if (formatState.currentColor != null) {
            component = (TextComponent)component.color(formatState.currentColor);
        }
        return component;
    }

    private static Component processResetCode(String textPart, FormatState formatState) {
        TextComponent component = Component.text((String)textPart.substring(1));
        for (TextDecoration decoration : _DECORATION_MAP.values()) {
            component = (TextComponent)component.decoration(decoration, false);
        }
        component = (TextComponent)component.color((TextColor)NamedTextColor.WHITE);
        formatState.resetFormatting();
        return component;
    }

    public static String componentToString(Component component) {
        return ComponentColor.componentToString(component, '&');
    }

    public static String componentToString(Component component, char altColorChar) {
        if (component == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        ComponentColor.appendComponentToString(component, result, altColorChar);
        return result.toString();
    }

    private static void appendComponentToString(Component component, StringBuilder builder, char altColorChar) {
        if (!(component instanceof TextComponent)) {
            for (Component child : component.children()) {
                ComponentColor.appendComponentToString(child, builder, altColorChar);
            }
            return;
        }
        TextComponent textComponent = (TextComponent)component;
        TextColor color = component.color();
        if (color != null) {
            if (color instanceof NamedTextColor) {
                NamedTextColor namedColor = (NamedTextColor)color;
                Character colorCode = _REVERSE_COLOR_MAP.get(namedColor);
                if (colorCode != null) {
                    builder.append(altColorChar).append(colorCode);
                } else {
                    String hexString = color.asHexString().toUpperCase();
                    builder.append(altColorChar).append(hexString);
                }
            } else {
                String hexString = color.asHexString().toUpperCase();
                builder.append(altColorChar).append(hexString);
            }
        }
        for (TextDecoration decoration : TextDecoration.values()) {
            Character decorationCode;
            if (component.decoration(decoration) != TextDecoration.State.TRUE || (decorationCode = _REVERSE_DECORATION_MAP.get(decoration)) == null) continue;
            builder.append(altColorChar).append(decorationCode);
        }
        builder.append(textComponent.content());
        for (Component child : component.children()) {
            ComponentColor.appendComponentToString(child, builder, altColorChar);
        }
    }

    static {
        _COLOR_MAP.put(Character.valueOf('0'), NamedTextColor.BLACK);
        _COLOR_MAP.put(Character.valueOf('1'), NamedTextColor.DARK_BLUE);
        _COLOR_MAP.put(Character.valueOf('2'), NamedTextColor.DARK_GREEN);
        _COLOR_MAP.put(Character.valueOf('3'), NamedTextColor.DARK_AQUA);
        _COLOR_MAP.put(Character.valueOf('4'), NamedTextColor.DARK_RED);
        _COLOR_MAP.put(Character.valueOf('5'), NamedTextColor.DARK_PURPLE);
        _COLOR_MAP.put(Character.valueOf('6'), NamedTextColor.GOLD);
        _COLOR_MAP.put(Character.valueOf('7'), NamedTextColor.GRAY);
        _COLOR_MAP.put(Character.valueOf('8'), NamedTextColor.DARK_GRAY);
        _COLOR_MAP.put(Character.valueOf('9'), NamedTextColor.BLUE);
        _COLOR_MAP.put(Character.valueOf('a'), NamedTextColor.GREEN);
        _COLOR_MAP.put(Character.valueOf('b'), NamedTextColor.AQUA);
        _COLOR_MAP.put(Character.valueOf('c'), NamedTextColor.RED);
        _COLOR_MAP.put(Character.valueOf('d'), NamedTextColor.LIGHT_PURPLE);
        _COLOR_MAP.put(Character.valueOf('e'), NamedTextColor.YELLOW);
        _COLOR_MAP.put(Character.valueOf('f'), NamedTextColor.WHITE);
        _DECORATION_MAP.put(Character.valueOf('k'), TextDecoration.OBFUSCATED);
        _DECORATION_MAP.put(Character.valueOf('l'), TextDecoration.BOLD);
        _DECORATION_MAP.put(Character.valueOf('m'), TextDecoration.STRIKETHROUGH);
        _DECORATION_MAP.put(Character.valueOf('n'), TextDecoration.UNDERLINED);
        _DECORATION_MAP.put(Character.valueOf('o'), TextDecoration.ITALIC);
        _COLOR_MAP.forEach((key, value) -> _REVERSE_COLOR_MAP.put((NamedTextColor)value, (Character)key));
        _DECORATION_MAP.forEach((key, value) -> _REVERSE_DECORATION_MAP.put((TextDecoration)value, (Character)key));
    }

    private static class FormatState {
        TextColor currentColor = null;
        ArrayList<TextDecoration> activeDecorations = new ArrayList();

        private FormatState() {
        }

        void resetFormatting() {
            this.currentColor = null;
            this.activeDecorations.clear();
        }
    }
}

