/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.util.Optional;
import java.util.function.UnaryOperator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.User;

public class MessageBuilder {
    private final String _messagePath;
    private final Type _type;
    private final User _receiver;
    private boolean _sendMessage = true;
    private boolean _sendPrefix = true;
    private boolean _format = true;
    private UnaryOperator<String> _preMessageModifier = null;
    private UnaryOperator<String> _postMessageModifier = null;
    private String _senderName;
    private String _targetName;
    private String _label;
    private String _syntaxPath;

    private MessageBuilder(String messagePath, Type type, User receiver) {
        this._messagePath = messagePath;
        this._type = type;
        this._receiver = receiver;
    }

    public static MessageBuilder general(String messagePath, User receiver) {
        return MessageBuilder.of(Type.GENERAL, messagePath, receiver);
    }

    public static MessageBuilder command(String messagePath, User receiver) {
        return MessageBuilder.of(Type.COMMAND, messagePath, receiver);
    }

    public static MessageBuilder syntax(String messagePath, User receiver) {
        return MessageBuilder.of(Type.SYNTAX, messagePath, receiver);
    }

    public static MessageBuilder sign(String messagePath, User receiver) {
        return MessageBuilder.of(Type.CLICKABLE_SIGN, messagePath, receiver);
    }

    public static MessageBuilder of(Type type, String messagePath, User receiver) {
        return new MessageBuilder(messagePath, type, receiver);
    }

    public MessageBuilder postModifier(UnaryOperator<String> messageModifier) {
        this._postMessageModifier = messageModifier;
        return this;
    }

    public MessageBuilder preModifier(UnaryOperator<String> messageModifier) {
        this._preMessageModifier = messageModifier;
        return this;
    }

    public MessageBuilder send(boolean sendMessage) {
        this._sendMessage = sendMessage;
        return this;
    }

    public MessageBuilder prefix(boolean sendPrefix) {
        this._sendPrefix = sendPrefix;
        return this;
    }

    public MessageBuilder target(String targetName) {
        this._targetName = targetName;
        return this;
    }

    public MessageBuilder sender(String senderName) {
        this._senderName = senderName;
        return this;
    }

    public MessageBuilder label(String label) {
        this._label = label;
        return this;
    }

    public MessageBuilder format(boolean format) {
        this._format = format;
        return this;
    }

    public MessageBuilder syntaxPath(String syntaxPath) {
        this._syntaxPath = syntaxPath;
        return this;
    }

    public Optional<String> build() {
        String formattedMessage;
        String messagePath = switch (this._type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "General." + this._messagePath;
            case 1 -> "Commands." + this._messagePath;
            case 3 -> "Syntax." + this._messagePath;
            case 2 -> "ClickableSigns." + this._messagePath;
        };
        Optional<String> messageOptional = MessageManager.getMessage(this._receiver, messagePath);
        if (messageOptional.isEmpty()) {
            if (this._messagePath.equalsIgnoreCase("ErrorOccurred")) {
                ServerSystem.getLog().severe("'ErrorOccurred' message could not be found, this is a critical error!");
                ServerSystem.getLog().severe("Please report this error to the server administrator!");
                this._receiver.sendMessage("Something went seriously wrong! Please contact an administrator of this server!");
                return Optional.empty();
            }
            MessageBuilder.general("ErrorOccurred", this._receiver).build();
            return Optional.empty();
        }
        String message = messageOptional.get();
        if (this._preMessageModifier != null) {
            message = (String)this._preMessageModifier.apply(message);
        }
        if (this._senderName != null) {
            message = message.replace("<SENDER>", this._senderName);
        }
        if (this._targetName == null) {
            this._targetName = this._receiver.getName().orElse("Unknown");
        }
        if (this._syntaxPath != null) {
            Optional<String> syntaxOptional = MessageBuilder.syntax(this._syntaxPath, this._receiver).sender(this._senderName).prefix(false).target(this._targetName).label(this._label).send(false).build();
            message = syntaxOptional.isPresent() ? message.replace("<USAGE>", syntaxOptional.get()) : message.replace("<USAGE>", "!!ERROR!!");
        }
        if (this._postMessageModifier != null) {
            message = (String)this._postMessageModifier.apply(message);
        }
        String string = formattedMessage = this._format ? MessageManager.formatMessage(message, this._receiver, this._targetName, this._label, this._sendPrefix) : message;
        if (this._sendMessage) {
            this._receiver.sendMessage(formattedMessage);
        }
        return Optional.of(formattedMessage);
    }

    public static enum Type {
        GENERAL,
        COMMAND,
        CLICKABLE_SIGN,
        SYNTAX;

    }
}

