/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.kit.manager.Kit;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.BanModeration;
import me.testaccount666.serversystem.moderation.MuteModeration;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class LegacyDataMigrator {
    private File _legacyDataDirectory;

    private Optional<OfflineUser> getOfflineUser(UUID uuid) {
        UserManager userManager = ServerSystem.Instance.getRegistry().getService(UserManager.class);
        Optional<CachedUser> userOptional = userManager.getUser(uuid);
        if (userOptional.isEmpty()) {
            ServerSystem.getLog().warning("Could not find user with UUID: " + String.valueOf(uuid));
            return Optional.empty();
        }
        return Optional.of(userOptional.get().getOfflineUser());
    }

    private void log(Level level, String message) {
        ServerSystem.getLog().log(level, message);
    }

    private void log(Level level, String message, Exception exception) {
        ServerSystem.getLog().log(level, message, exception);
    }

    private void processRecords(Connection connection, String query, String recordType, SqlRecordProcessor recordProcessor) {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            int migratedCount = 0;
            while (resultSet.next()) {
                try {
                    recordProcessor.process(resultSet, migratedCount);
                    ++migratedCount;
                }
                catch (Exception exception) {
                    this.log(Level.WARNING, "Failed to migrate a " + recordType + " record: " + exception.getMessage(), exception);
                }
            }
            this.log(Level.INFO, "Successfully migrated " + migratedCount + " " + recordType + " records");
        }
        catch (SQLException exception) {
            this.log(Level.SEVERE, "Error querying " + recordType + " database: " + exception.getMessage(), exception);
        }
    }

    private void withConnection(String url, Consumer<Connection> processor) {
        try (Connection connection = DriverManager.getConnection(url);){
            processor.accept(connection);
        }
        catch (SQLException exception) {
            this.log(Level.SEVERE, "Error connecting to database: " + exception.getMessage(), exception);
        }
    }

    private void applyModeration(UUID targetUuid, AbstractModeration moderation) {
        this.getOfflineUser(targetUuid).ifPresent(user -> {
            if (moderation instanceof BanModeration) {
                AbstractModerationManager banManager = user.getBanManager();
                if (banManager == null) {
                    this.log(Level.WARNING, "Bam manager is null for user: " + String.valueOf(targetUuid));
                    return;
                }
                banManager.addModeration(moderation);
            }
            if (moderation instanceof MuteModeration) {
                AbstractModerationManager muteManager = user.getMuteManager();
                if (muteManager == null) {
                    this.log(Level.WARNING, "Mute manager is null for user: " + String.valueOf(targetUuid));
                    return;
                }
                muteManager.addModeration(moderation);
            }
        });
    }

    public boolean isLegacyDataPresent() {
        File directory = ServerSystem.Instance.getDataFolder();
        if (!directory.exists()) {
            return false;
        }
        File previousVersionFile = new File(directory, "previousVersion.yml");
        if (!previousVersionFile.exists()) {
            return true;
        }
        YamlConfiguration previousVersionConfig = YamlConfiguration.loadConfiguration((File)previousVersionFile);
        String previousVersion = previousVersionConfig.getString("previousVersion", "");
        if (!previousVersion.contains(".")) {
            try {
                int verInt = Integer.parseInt(previousVersion);
                if (verInt < 300) {
                    return true;
                }
                CharSequence[] split = previousVersion.split("");
                if ((previousVersion = String.join((CharSequence)".", split).trim()).startsWith(".")) {
                    previousVersion = previousVersion.substring(1);
                }
                if (previousVersion.endsWith(".")) {
                    previousVersion = previousVersion.substring(0, previousVersion.length() - 1);
                }
                if (previousVersion.isEmpty()) {
                    return true;
                }
            }
            catch (NumberFormatException exception) {
                return true;
            }
        }
        return new Version(previousVersion).compareTo(new Version("3.0.0")) < 0;
    }

    public void prepareMigration() {
        File directory = ServerSystem.Instance.getDataFolder();
        if (!directory.exists()) {
            return;
        }
        this._legacyDataDirectory = new File(directory.getParent(), "ServerSystem-LegacyData-" + System.currentTimeMillis());
        directory.renameTo(this._legacyDataDirectory);
    }

    public void migrateLegacyData() {
        this.migrateModerationAndEconomy();
        this.migrateHomes();
        this.migrateWarps();
        this.migrateKits();
    }

    private void migrateKits() {
        File legacyKitsFile = new File(this._legacyDataDirectory, "kits.yml");
        if (!legacyKitsFile.exists()) {
            return;
        }
        YamlConfiguration legacyKitsConfig = YamlConfiguration.loadConfiguration((File)legacyKitsFile);
        this.log(Level.INFO, "Legacy Kits Data detected. Migrating...");
        ConfigurationSection kitsSection = legacyKitsConfig.getConfigurationSection("Kits");
        if (kitsSection == null) {
            this.log(Level.WARNING, "No kits found in legacy kits file");
            return;
        }
        Set kitNames = kitsSection.getKeys(false);
        int migratedCount = 0;
        ItemStack defaultItem = new ItemStack(Material.AIR);
        KitManager kitManager = ServerSystem.Instance.getRegistry().getService(KitManager.class);
        if (kitManager == null) {
            this.log(Level.WARNING, "Kit manager is null, skipping kits migration");
            return;
        }
        for (String kitName : kitNames) {
            try {
                ItemStack offhandItem = kitsSection.getItemStack(kitName + ".40", defaultItem);
                ItemStack feetItem = kitsSection.getItemStack(kitName + ".39", defaultItem);
                ItemStack legsItem = kitsSection.getItemStack(kitName + ".38", defaultItem);
                ItemStack chestplateItem = kitsSection.getItemStack(kitName + ".37", defaultItem);
                ItemStack helmetItem = kitsSection.getItemStack(kitName + ".36", defaultItem);
                ItemStack[] armorContents = new ItemStack[]{helmetItem, chestplateItem, legsItem, feetItem};
                for (int index = 0; index < armorContents.length; ++index) {
                    ItemStack armor = armorContents[index];
                    if (armor.getType() == Material.AIR) {
                        armor = null;
                    }
                    armorContents[index] = armor;
                }
                ItemStack[] inventoryContents = new ItemStack[36];
                for (int index = 0; index < 36; ++index) {
                    ItemStack item = kitsSection.getItemStack(kitName + "." + index, defaultItem);
                    if (item.getType() == Material.AIR) {
                        item = null;
                    }
                    inventoryContents[index] = item;
                }
                long cooldown = kitsSection.getLong(kitName + ".Delay", -1L);
                Kit kit = new Kit(kitName, cooldown, offhandItem, armorContents, inventoryContents);
                kitManager.addKit(kit);
                ++migratedCount;
            }
            catch (Exception exception) {
                this.log(Level.WARNING, "Failed to migrate kit '" + kitName + "': " + exception.getMessage(), exception);
            }
        }
        kitManager.saveAllKits();
        this.log(Level.INFO, "Successfully migrated " + migratedCount + " kits from legacy data directory: " + this._legacyDataDirectory.getAbsolutePath());
    }

    private void migrateWarps() {
        File legacyWarpsFile = new File(this._legacyDataDirectory, "warps.yml");
        if (!legacyWarpsFile.exists()) {
            return;
        }
        YamlConfiguration legacyWarpsConfig = YamlConfiguration.loadConfiguration((File)legacyWarpsFile);
        this.log(Level.INFO, "Legacy Warp Data detected. Migrating...");
        if (!legacyWarpsConfig.isConfigurationSection("Warps")) {
            this.log(Level.WARNING, "No warps found in legacy warps file");
            return;
        }
        WarpManager warpManager = ServerSystem.Instance.getRegistry().getService(WarpManager.class);
        ConfigurationSection warpSection = legacyWarpsConfig.getConfigurationSection("Warps");
        Set warpNames = warpSection.getKeys(false);
        int migratedCount = 0;
        for (String warpName : warpNames) {
            try {
                String prefix = "Warps." + warpName;
                double x = legacyWarpsConfig.getDouble(prefix + ".X");
                double y = legacyWarpsConfig.getDouble(prefix + ".Y");
                double z = legacyWarpsConfig.getDouble(prefix + ".Z");
                float yaw = (float)legacyWarpsConfig.getDouble(prefix + ".Yaw");
                float pitch = (float)legacyWarpsConfig.getDouble(prefix + ".Pitch");
                String worldName = legacyWarpsConfig.getString(prefix + ".World");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    this.log(Level.WARNING, "World '" + worldName + "' not found for warp '" + warpName + "', skipping");
                    continue;
                }
                Location location = new Location(world, x, y, z, yaw, pitch);
                Optional<Warp> warp = Warp.of(warpName, location);
                if (warp.isEmpty()) {
                    this.log(Level.WARNING, "Warp name '" + warpName + "' contains invalid characters, skipping");
                    continue;
                }
                warpManager.addWarp(warp.get());
                ++migratedCount;
            }
            catch (Exception exception) {
                this.log(Level.WARNING, "Failed to migrate warp '" + warpName + "'", exception);
            }
        }
        this.log(Level.INFO, "Successfully migrated " + migratedCount + " warps");
    }

    private void migrateHomes() {
        File legacyHomesDirectory = new File(this._legacyDataDirectory, "Homes");
        if (!legacyHomesDirectory.exists()) {
            return;
        }
        if (!legacyHomesDirectory.isDirectory()) {
            return;
        }
        File[] legacyHomesFiles = legacyHomesDirectory.listFiles();
        if (legacyHomesFiles == null) {
            return;
        }
        this.log(Level.INFO, "Legacy Home Data detected. Migrating...");
        int count = 0;
        for (File homesFile : legacyHomesFiles) {
            if (!homesFile.isFile()) continue;
            try {
                UUID uuid = UUID.fromString(homesFile.getName().replace(".yml", ""));
                YamlConfiguration legacyHomesConfig = YamlConfiguration.loadConfiguration((File)homesFile);
                count += this.migrateHome(uuid, (FileConfiguration)legacyHomesConfig);
            }
            catch (IllegalArgumentException exception) {
                this.log(Level.WARNING, "Failed to migrate homes for " + homesFile.getName(), exception);
            }
        }
        this.log(Level.INFO, "Successfully migrated " + count + " homes from legacy data directory: " + this._legacyDataDirectory.getAbsolutePath());
    }

    private int migrateHome(UUID uuid, FileConfiguration legacyHomesConfig) {
        Optional<OfflineUser> userOpt = this.getOfflineUser(uuid);
        if (userOpt.isEmpty()) {
            return 0;
        }
        OfflineUser user = userOpt.get();
        if (!legacyHomesConfig.isConfigurationSection("Homes")) {
            return 0;
        }
        ConfigurationSection homeSection = legacyHomesConfig.getConfigurationSection("Homes");
        Set homeNames = homeSection.getKeys(false);
        int migratedCount = 0;
        for (String homeName : homeNames) {
            try {
                Location location = legacyHomesConfig.getLocation("Homes." + homeName);
                Optional<Home> home = Home.of(homeName, location);
                if (home.isEmpty()) {
                    this.log(Level.WARNING, "Home name '" + homeName + "' (" + String.valueOf(uuid) + ") contains invalid characters, skipping");
                    continue;
                }
                user.getHomeManager().addHome(home.get());
                ++migratedCount;
            }
            catch (Exception exception) {
                this.log(Level.WARNING, "Failed to migrate home '" + homeName + "' for " + String.valueOf(uuid) + ": " + exception.getMessage(), exception);
            }
        }
        user.save();
        return migratedCount;
    }

    private void migrateModerationAndEconomy() {
        File economyFile;
        File mutesFile;
        File bansFile;
        File legacyConfigFile = new File(this._legacyDataDirectory, "config.yml");
        YamlConfiguration legacyConfig = YamlConfiguration.loadConfiguration((File)legacyConfigFile);
        if (legacyConfig.getBoolean("mysql.use", false)) {
            this.log(Level.INFO, "Legacy MySQL configuration detected. Migrating...");
            this.migrateMySqlConfig((FileConfiguration)legacyConfig);
        }
        if (legacyConfig.getBoolean("sqlite.use", false)) {
            this.log(Level.INFO, "Legacy SQLite configuration detected. Migrating...");
        }
        if (legacyConfig.getBoolean("h2.use", false)) {
            this.log(Level.INFO, "Legacy H2 configuration detected. Migrating...");
            this.migrateH2Config((FileConfiguration)legacyConfig);
        }
        if ((bansFile = new File(this._legacyDataDirectory, "bans.sqlite")).exists()) {
            this.migrateBansFile(bansFile);
        }
        if ((mutesFile = new File(this._legacyDataDirectory, "mutes.sqlite")).exists()) {
            this.migrateMutesFile(mutesFile);
        }
        if ((economyFile = new File(this._legacyDataDirectory, "economy.sqlite")).exists()) {
            this.migrateEconomyFile(economyFile);
        }
    }

    private void migrateBansFile(File bansFile) {
        this.log(Level.INFO, "Migrating bans from legacy database: " + bansFile.getAbsolutePath());
        String url = "jdbc:sqlite:" + bansFile.getAbsolutePath();
        this.withConnection(url, connection -> this.processBanRecords((Connection)connection, "Sqlite Ban"));
    }

    private void processBanRecords(Connection connection, String recordType) {
        this.processRecords(connection, "SELECT * FROM BannedPlayers", recordType, (resultSet, count) -> {
            String bannedUuidStr = resultSet.getString("BannedUUID");
            String senderUuidStr = resultSet.getString("SenderUUID");
            String reason = resultSet.getString("Reason");
            long unbanTime = resultSet.getLong("UnbanTime");
            UUID bannedUuid = UUID.fromString(bannedUuidStr);
            UUID senderUuid = this.parseSenderUuid(senderUuidStr);
            long issueTime = System.currentTimeMillis();
            AbstractModeration banModeration = ((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)BanModeration.builder().issueTime(issueTime)).expireTime(unbanTime)).reason(reason)).senderUuid(senderUuid)).targetUuid(bannedUuid)).build();
            this.applyModeration(bannedUuid, banModeration);
        });
    }

    private UUID parseSenderUuid(String senderUuidStr) {
        try {
            return UUID.fromString(senderUuidStr);
        }
        catch (IllegalArgumentException ignored) {
            return ConsoleUser.CONSOLE_UUID;
        }
    }

    private void migrateMutesFile(File mutesFile) {
        this.log(Level.INFO, "Migrating mutes from legacy database: " + mutesFile.getAbsolutePath());
        String url = "jdbc:sqlite:" + mutesFile.getAbsolutePath();
        this.withConnection(url, connection -> this.processMuteRecords((Connection)connection, "mute"));
    }

    private void processMuteRecords(Connection connection, String recordType) {
        this.processRecords(connection, "SELECT * FROM MutedPlayers", recordType, (resultSet, count) -> {
            String bannedUuidStr = resultSet.getString("BannedUUID");
            String senderUuidStr = resultSet.getString("SenderUUID");
            String reason = resultSet.getString("Reason");
            long unbanTime = resultSet.getLong("UnbanTime");
            boolean isShadowMute = resultSet.getInt("Shadow") >= 1;
            UUID bannedUuid = UUID.fromString(bannedUuidStr);
            UUID senderUuid = this.parseSenderUuid(senderUuidStr);
            long issueTime = System.currentTimeMillis();
            AbstractModeration muteModeration = ((MuteModeration.MuteModerationBuilder)((MuteModeration.MuteModerationBuilder)((MuteModeration.MuteModerationBuilder)((MuteModeration.MuteModerationBuilder)((MuteModeration.MuteModerationBuilder)((MuteModeration.MuteModerationBuilder)MuteModeration.builder().issueTime(issueTime)).expireTime(unbanTime)).reason(reason)).senderUuid(senderUuid)).targetUuid(bannedUuid)).isShadowMute(isShadowMute)).build();
            this.applyModeration(bannedUuid, muteModeration);
        });
    }

    private void migrateEconomyFile(File economyFile) {
        this.log(Level.INFO, "Migrating economy from legacy database: " + economyFile.getAbsolutePath());
        String url = "jdbc:sqlite:" + economyFile.getAbsolutePath();
        this.withConnection(url, connection -> this.processEconomyRecords((Connection)connection, "SELECT * FROM Economy", "economy"));
    }

    private void processEconomyRecords(Connection connection, String query, String recordType) {
        this.processRecords(connection, query, recordType, (resultSet, count) -> {
            UUID ownerUuid = UUID.fromString(resultSet.getString("UUID"));
            BigDecimal balance = resultSet.getBigDecimal("Balance");
            this.getOfflineUser(ownerUuid).ifPresent(user -> {
                AbstractBankAccount bankAccount = user.getBankAccount();
                bankAccount.setBalance(balance);
            });
        });
    }

    private void migrateMySqlConfig(FileConfiguration legacyConfig) {
        String hostname = legacyConfig.getString("mysql.hostname", "127.0.0.1");
        String port = legacyConfig.getString("mysql.port", "3306");
        String username = legacyConfig.getString("mysql.username", "root");
        String password = legacyConfig.getString("mysql.password", "");
        String database = legacyConfig.getString("mysql.database", "ServerSystem");
        boolean economyEnabled = legacyConfig.getBoolean("mysql.economy.enabled", false);
        String economyServerName = legacyConfig.getString("mysql.economy.serverName", "global");
        boolean banSystemEnabled = legacyConfig.getBoolean("mysql.banSystem", false);
        String jdbcUrl = "jdbc:mysql://" + hostname + ":" + port + "/" + database;
        try (Connection connection = DriverManager.getConnection(jdbcUrl, username, password);){
            this.log(Level.INFO, "Successfully connected to MySQL database. Migrating data...");
            if (economyEnabled) {
                this.migrateEconomyFromMySql(connection, economyServerName);
            }
            if (banSystemEnabled) {
                this.migrateBansFromMySql(connection);
            }
        }
        catch (SQLException exception) {
            this.log(Level.WARNING, "Failed to connect to MySQL database: " + exception.getMessage(), exception);
        }
    }

    private void migrateH2Config(FileConfiguration legacyConfig) {
        boolean economyEnabled = legacyConfig.getBoolean("h2.economy", false);
        boolean banSystemEnabled = legacyConfig.getBoolean("h2.banSystem", false);
        File h2EconomyFile = new File(this._legacyDataDirectory, "economy.h2.db");
        File h2BansFile = new File(this._legacyDataDirectory, "bans.h2.db");
        File h2MutesFile = new File(this._legacyDataDirectory, "mutes.h2.db");
        if (economyEnabled && h2EconomyFile.exists()) {
            this.log(Level.INFO, "H2 economy database found. Converting to SQLite...");
            this.migrateH2(h2EconomyFile, "economy");
        }
        if (banSystemEnabled && h2BansFile.exists()) {
            this.log(Level.INFO, "H2 bans database found. Converting to SQLite...");
            this.migrateH2(h2BansFile, "bans");
        }
        if (banSystemEnabled && h2MutesFile.exists()) {
            this.log(Level.INFO, "H2 mutes database found. Converting to SQLite...");
            this.migrateH2(h2MutesFile, "mutes");
        }
    }

    private void migrateEconomyFromMySql(Connection connection, String serverName) {
        this.processEconomyRecords(connection, "SELECT * FROM Economy WHERE ServerName = '" + serverName + "'", "MySQL economy");
    }

    private void migrateBansFromMySql(Connection connection) {
        this.processBanRecords(connection, "MySQL ban");
    }

    private void migrateH2(File h2File, String type) {
        this.log(Level.INFO, "Migrating " + type + " from H2 database: " + h2File.getAbsolutePath());
        String h2Path = h2File.getAbsolutePath();
        if (h2Path.endsWith(".h2.db")) {
            h2Path = h2Path.substring(0, h2Path.length() - 6);
        }
        String url = "jdbc:h2:file:" + h2Path;
        try {
            Class.forName("org.h2.Driver");
            this.withConnection(url, connection -> {
                this.log(Level.INFO, "Successfully connected to H2 database.");
                if (type.equalsIgnoreCase("economy")) {
                    this.processEconomyRecords((Connection)connection, "SELECT * FROM Economy", "H2 economy");
                } else if (type.equalsIgnoreCase("bans")) {
                    this.processBanRecords((Connection)connection, "H2 ban");
                } else if (type.equalsIgnoreCase("mutes")) {
                    this.processMuteRecords((Connection)connection, "H2 mute");
                }
            });
        }
        catch (ClassNotFoundException exception) {
            this.log(Level.SEVERE, "H2 driver not found. Make sure the H2 library is properly included: " + exception.getMessage(), exception);
        }
    }

    @FunctionalInterface
    private static interface SqlRecordProcessor {
        public void process(ResultSet var1, int var2) throws Exception;
    }
}

