/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public abstract class AbstractMigrator {
    protected Essentials essentials() {
        return (Essentials)Essentials.getPlugin(Essentials.class);
    }

    protected UserManager userManager() {
        return ServerSystem.Instance.getRegistry().getService(UserManager.class);
    }

    protected OfflinePlayer[] offlinePlayers() {
        return Bukkit.getOfflinePlayers();
    }

    protected void ensureUserDataExists(UUID uuid) {
        File userFile;
        Path userDataDirectory = Path.of("plugins", "Essentials", "userdata");
        if (!userDataDirectory.toFile().exists()) {
            userDataDirectory.toFile().mkdirs();
        }
        if (!(userFile = userDataDirectory.resolve(String.valueOf(uuid) + ".yml").toFile()).exists()) {
            userFile.createNewFile();
        }
    }

    public abstract int migrateFrom();

    public abstract int migrateTo();
}

