/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;

public class HomeMigrator
extends AbstractMigrator {
    @Override
    public int migrateFrom() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        Set uuids = essentials.getUsers().getAllUserUUIDs();
        for (UUID uuid : uuids) {
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping home migration!");
                continue;
            }
            count += this.migrateFrom(userOptional.get().getOfflineUser());
        }
        return count;
    }

    private int migrateFrom(OfflineUser user) {
        int count = 0;
        HomeManager homeManager = user.getHomeManager();
        Essentials essentials = this.essentials();
        User essentialsUser = essentials.getUser(user.getUuid());
        for (String homeName : essentialsUser.getHomes()) {
            try {
                Location location = essentialsUser.getHome(homeName);
                homeManager.addHome(homeName, location);
                ++count;
            }
            catch (IllegalArgumentException exception) {
                String userName = user.getName().orElse("Unknown");
                ServerSystem.getLog().log(Level.WARNING, "Couldn't migrate home '" + homeName + "' for user '" + String.valueOf(user.getUuid()) + "' (" + userName + ")", exception);
            }
        }
        user.save();
        return count;
    }

    @Override
    public int migrateTo() {
        int count = 0;
        UserManager userManager = this.userManager();
        for (OfflinePlayer player : this.offlinePlayers()) {
            UUID uuid = player.getUniqueId();
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping home migration!");
                continue;
            }
            count += this.migrateTo(userOptional.get().getOfflineUser());
        }
        return count;
    }

    private int migrateTo(OfflineUser user) {
        int count = 0;
        HomeManager homeManager = user.getHomeManager();
        Essentials essentials = this.essentials();
        this.ensureUserDataExists(user.getUuid());
        User essentialsUser = essentials.getUser(user.getUuid());
        for (Home home : homeManager.getHomes()) {
            String homeName = home.getDisplayName();
            Location location = home.getLocation();
            try {
                essentialsUser.setHome(homeName, location);
                ++count;
            }
            catch (Exception exception) {
                String userName = user.getName().orElse("Unknown");
                ServerSystem.getLog().log(Level.WARNING, "Couldn't migrate home '" + homeName + "' for user '" + String.valueOf(user.getUuid()) + "' (" + userName + ")", exception);
            }
        }
        return count;
    }
}

