/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.MuteModeration;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.OfflinePlayer;

public class MuteMigrator
extends AbstractMigrator {
    @Override
    public int migrateFrom() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        Set uuids = essentials.getUsers().getAllUserUUIDs();
        for (UUID uuid : uuids) {
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping state migration!");
                continue;
            }
            User essentialsUser = essentials.getUser(uuid);
            OfflineUser user = userOptional.get().getOfflineUser();
            if (!essentialsUser.isMuted()) continue;
            Optional<String> defaultReason = MessageBuilder.command("Moderation.DefaultReason", UserManager.getConsoleUser()).target(essentialsUser.getName()).prefix(false).send(false).build();
            if (defaultReason.isEmpty()) {
                ServerSystem.getLog().severe("(MuteMigrator) Default reason is empty! This should not happen! (Mute Migration cancelled)");
                return count;
            }
            AbstractModerationManager muteManager = user.getMuteManager();
            long expireTime = essentialsUser.getMuteTimeout();
            long issueTime = System.currentTimeMillis();
            String reason = essentialsUser.getMuteReason();
            if (reason == null) {
                reason = defaultReason.get();
            }
            UUID senderUUID = UserManager.getConsoleUser().getUuid();
            UUID targetUUID = user.getUuid();
            muteManager.addModeration(new MuteModeration(false, issueTime, expireTime, reason, senderUUID, targetUUID));
            user.save();
            ++count;
        }
        return count;
    }

    @Override
    public int migrateTo() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        for (OfflinePlayer player : this.offlinePlayers()) {
            UUID uuid = player.getUniqueId();
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping mute migration!");
                continue;
            }
            OfflineUser user = userOptional.get().getOfflineUser();
            this.ensureUserDataExists(uuid);
            User essentialsUser = essentials.getUser(uuid);
            AbstractModerationManager muteManager = user.getMuteManager();
            Optional<AbstractModeration> muteOptional = muteManager.getActiveModeration();
            if (muteOptional.isEmpty()) continue;
            AbstractModeration mute = muteOptional.get();
            essentialsUser.setMuted(true);
            essentialsUser.setMuteReason(mute.reason());
            essentialsUser.setMuteTimeout(mute.expireTime());
            ++count;
        }
        return count;
    }
}

