/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.OfflinePlayer;

public class PlayerStateMigrator
extends AbstractMigrator {
    @Override
    public int migrateFrom() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        Set uuids = essentials.getUsers().getAllUserUUIDs();
        for (UUID uuid : uuids) {
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping state migration!");
                continue;
            }
            User essentialsUser = essentials.getUser(uuid);
            OfflineUser user = userOptional.get().getOfflineUser();
            user.setAcceptsMessages(!essentialsUser.isIgnoreMsg());
            user.setSocialSpyEnabled(essentialsUser.isSocialSpyEnabled());
            user.setAcceptsTeleports(essentialsUser.isTeleportEnabled());
            user.setGodMode(essentialsUser.isGodModeEnabled());
            user.setVanish(essentialsUser.isVanished());
            user.setLogoutPosition(essentialsUser.getLogoutLocation());
            user.save();
            ++count;
        }
        return count;
    }

    @Override
    public int migrateTo() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        for (OfflinePlayer player : this.offlinePlayers()) {
            UUID uuid = player.getUniqueId();
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping state migration!");
                continue;
            }
            CachedUser cachedUser = userOptional.get();
            OfflineUser user = cachedUser.getOfflineUser();
            this.ensureUserDataExists(uuid);
            User essentialsUser = essentials.getUser(uuid);
            essentialsUser.setIgnoreMsg(!user.isAcceptsMessages());
            essentialsUser.setSocialSpyEnabled(user.isSocialSpyEnabled());
            essentialsUser.setTeleportEnabled(user.isAcceptsTeleports());
            essentialsUser.setGodModeEnabled(user.isGodMode());
            if (cachedUser.isOnlineUser()) {
                essentialsUser.setVanished(user.isVanish());
            }
            essentialsUser.setLogoutLocation(user.getLogoutPosition());
            ++count;
        }
        return count;
    }
}

