/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns;

import me.testaccount666.serversystem.clickablesigns.SignClickAction;
import me.testaccount666.serversystem.clickablesigns.cost.CostHandler;
import me.testaccount666.serversystem.clickablesigns.util.SignUtils;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class AbstractSignClickAction
implements SignClickAction {
    @Override
    public String getUsePermissionNode() {
        return this.getBasePermissionNode() + ".Use";
    }

    @Override
    public String getDestroyPermissionNode() {
        return this.getBasePermissionNode() + ".Destroy";
    }

    protected abstract boolean executeAction(User var1, Sign var2, FileConfiguration var3);

    @Override
    public void execute(User user, Sign sign) {
        if (!PermissionManager.hasPermission(user, this.getUsePermissionNode(), false)) {
            MessageBuilder.general("NoPermission", user).postModifier(message -> message.replace("<PERMISSION>", PermissionManager.getPermission(this.getUsePermissionNode()))).build();
            return;
        }
        FileConfiguration config = SignUtils.loadSignConfig(sign.getLocation());
        if (!CostHandler.deductCost(user, config)) {
            return;
        }
        if (!this.executeAction(user, sign, config)) {
            CostHandler.refundCost(user, config);
        }
    }
}

