/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.testaccount666.serversystem.clickablesigns.SignType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class SignManager {
    private final Map<Location, SignType> _signTypes = new HashMap<Location, SignType>();
    private final File _signDirectory = Path.of("plugins", "ServerSystem", "data", "signs").toFile();

    public void addSignType(Location location, SignType signType) {
        this._signTypes.put(location, signType);
    }

    public void removeSignType(Location location) {
        this._signTypes.remove(location);
    }

    public Optional<SignType> getSignType(Location location) {
        return Optional.ofNullable(this._signTypes.get(location));
    }

    public void loadSignTypes() {
        if (!this._signDirectory.exists()) {
            return;
        }
        File[] files = this._signDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            Optional<SignType> signTypeOptional;
            YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)file);
            String key = fileConfig.getString("Key");
            if (key == null || (signTypeOptional = SignType.getSignTypeByKey(key)).isEmpty()) continue;
            SignType signType = signTypeOptional.get();
            String locationString = file.getName().substring(0, file.getName().indexOf("."));
            String[] locationSplit = locationString.split("_");
            if (locationSplit.length != 4) continue;
            String worldName = locationSplit[0];
            String xString = locationSplit[1];
            String yString = locationSplit[2];
            String zString = locationSplit[3];
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            int x = Integer.parseInt(xString);
            int y = Integer.parseInt(yString);
            int z = Integer.parseInt(zString);
            Location location = new Location(world, (double)x, (double)y, (double)z);
            this.addSignType(location, signType);
        }
    }
}

