/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.cost;

import java.math.BigDecimal;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.cost.CostType;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CostHandler {
    public static boolean canAfford(User user, FileConfiguration config) {
        CostType costType = CostHandler.getCostType(config);
        if (costType == CostType.NONE) {
            return true;
        }
        double costAmount = config.getDouble("Cost.Amount", 0.0);
        if (costAmount <= 0.0) {
            return true;
        }
        if (costType == CostType.EXP) {
            return (double)user.getPlayer().getTotalExperience() >= costAmount;
        }
        if (costType == CostType.ECONOMY) {
            AbstractBankAccount bankAccount = user.getBankAccount();
            if (bankAccount == null) {
                return false;
            }
            return bankAccount.hasEnoughMoney(BigDecimal.valueOf(costAmount));
        }
        return false;
    }

    public static void refundCost(User user, FileConfiguration config) {
        CostType costType = CostHandler.getCostType(config);
        if (costType == CostType.NONE) {
            return;
        }
        double costAmount = config.getDouble("Cost.Amount", 0.0);
        if (costAmount <= 0.0) {
            return;
        }
        if (costType == CostType.EXP) {
            Player player = user.getPlayer();
            player.setTotalExperience(player.getTotalExperience() + (int)costAmount);
            return;
        }
        if (costType == CostType.ECONOMY) {
            AbstractBankAccount bankAccount = user.getBankAccount();
            if (bankAccount == null) {
                return;
            }
            try {
                bankAccount.deposit(BigDecimal.valueOf(costAmount));
                bankAccount.save();
            }
            catch (Exception exception) {
                ServerSystem.getLog().log(Level.SEVERE, "Failed to refund cost for '" + String.valueOf(user.getName()) + "', failed to save bank account", exception);
                MessageBuilder.general("ErrorOccurred", user).build();
            }
        }
    }

    public static boolean deductCost(User user, FileConfiguration config) {
        CostType costType = CostHandler.getCostType(config);
        if (costType == CostType.NONE) {
            return true;
        }
        double costAmount = config.getDouble("Cost.Amount", 0.0);
        if (costAmount <= 0.0) {
            return true;
        }
        if (!CostHandler.canAfford(user, config)) {
            if (costType == CostType.EXP) {
                MessageBuilder.sign("Cost.NotEnoughExp", user).postModifier(message -> message.replace("<COST>", String.valueOf((int)costAmount))).build();
            } else if (costType == CostType.ECONOMY) {
                MessageBuilder.sign("Cost.NotEnoughMoney", user).postModifier(message -> message.replace("<COST>", String.valueOf(costAmount))).build();
            }
            return false;
        }
        if (costType == CostType.EXP) {
            Player player = user.getPlayer();
            player.setTotalExperience(player.getTotalExperience() - (int)costAmount);
            MessageBuilder.sign("Cost.PaidExp", user).postModifier(message -> message.replace("<COST>", String.valueOf((int)costAmount))).build();
            return true;
        }
        if (costType == CostType.ECONOMY) {
            AbstractBankAccount bankAccount = user.getBankAccount();
            if (bankAccount == null) {
                return false;
            }
            try {
                bankAccount.withdraw(BigDecimal.valueOf(costAmount));
                bankAccount.save();
                MessageBuilder.sign("Cost.PaidMoney", user).postModifier(message -> message.replace("<COST>", String.valueOf(costAmount))).build();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static CostType getCostType(FileConfiguration config) {
        String costTypeStr = config.getString("Cost.Type", "NONE");
        try {
            return CostType.valueOf(costTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return CostType.NONE;
        }
    }
}

