/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.time;

import me.testaccount666.serversystem.clickablesigns.AbstractSignConfigurator;
import me.testaccount666.serversystem.clickablesigns.SignType;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfiguratorTimeSign
extends AbstractSignConfigurator {
    @Override
    protected String getCreatePermissionNode() {
        return "ClickableSigns.Time.Create";
    }

    @Override
    protected SignType getSignType() {
        return SignType.TIME;
    }

    @Override
    protected boolean validateConfiguration(User user, Sign sign, YamlConfiguration config) {
        SignSide front = sign.getSide(Side.FRONT);
        String timeType = front.getLine(1).toLowerCase();
        if (timeType.isEmpty()) {
            MessageBuilder.sign("Time.NoTimeSpecified", user).build();
            return false;
        }
        if (!this.isValidTimeType(timeType)) {
            MessageBuilder.sign("Time.InvalidTime", user).postModifier(message -> message.replace("<TIME>", timeType)).build();
            return false;
        }
        front.line(0, ComponentColor.translateToComponent(SignType.TIME.signName()));
        front.line(1, ComponentColor.translateToComponent("&2" + timeType));
        SignSide back = sign.getSide(Side.BACK);
        for (int index = 0; index < 4; ++index) {
            back.line(index, front.line(index));
        }
        sign.update();
        return true;
    }

    @Override
    protected void addSignSpecificConfiguration(User user, Sign sign, FileConfiguration config) {
        String timeType = sign.getSide(Side.FRONT).getLine(1).toLowerCase();
        timeType = ChatColor.stripColor(timeType);
        config.set("TimeType", (Object)timeType);
    }

    @Override
    protected String getSuccessMessageKey() {
        return "Time.Created";
    }

    private boolean isValidTimeType(String timeType) {
        return timeType.equals("day") || timeType.equals("night") || timeType.equals("noon") || timeType.equals("midnight") || timeType.matches("\\d+");
    }
}

