/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.warp;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.AbstractSignClickAction;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;

public class ActionWarpSign
extends AbstractSignClickAction {
    @Override
    public String getBasePermissionNode() {
        return "ClickableSigns.Warp";
    }

    @Override
    protected boolean executeAction(User user, Sign sign, FileConfiguration config) {
        WarpManager warpManager = ServerSystem.Instance.getRegistry().getService(WarpManager.class);
        if (warpManager == null) {
            MessageBuilder.sign("Warp.NoWarpManager", user).build();
            return false;
        }
        String warpName = config.getString("WarpName", sign.getLine(1));
        if ((warpName = ChatColor.stripColor(warpName)).isEmpty()) {
            MessageBuilder.sign("Warp.NoWarpSpecified", user).build();
            return false;
        }
        Optional<Warp> warpOptional = warpManager.getWarpByName(warpName);
        if (warpOptional.isEmpty()) {
            String finalWarpName = warpName;
            MessageBuilder.sign("Warp.WarpNotFound", user).postModifier(message -> message.replace("<WARP>", finalWarpName)).build();
            return false;
        }
        Warp warp = warpOptional.get();
        user.getPlayer().teleport(warp.getLocation());
        MessageBuilder.sign("Warp.Teleported", user).postModifier(message -> message.replace("<WARP>", warp.getDisplayName())).build();
        return true;
    }
}

