/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.weather;

import me.testaccount666.serversystem.clickablesigns.AbstractSignClickAction;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;

public class ActionWeatherSign
extends AbstractSignClickAction {
    @Override
    public String getBasePermissionNode() {
        return "ClickableSigns.Weather";
    }

    @Override
    protected boolean executeAction(User user, Sign sign, FileConfiguration config) {
        String weatherType = config.getString("WeatherType", sign.getLine(1)).toLowerCase();
        if ((weatherType = ChatColor.stripColor(weatherType)).isEmpty()) {
            MessageBuilder.sign("Weather.NoWeatherSpecified", user).build();
            return false;
        }
        World world = user.getPlayer().getWorld();
        String finalWeatherType = weatherType;
        return switch (weatherType) {
            case "sun", "clear" -> {
                world.setStorm(false);
                world.setThundering(false);
                MessageBuilder.sign("Weather.WeatherSet", user).postModifier(message -> message.replace("<WEATHER>", "clear")).build();
                yield true;
            }
            case "rain", "storm" -> {
                world.setStorm(true);
                world.setThundering(false);
                MessageBuilder.sign("Weather.WeatherSet", user).postModifier(message -> message.replace("<WEATHER>", "rain")).build();
                yield true;
            }
            case "thunder" -> {
                world.setStorm(true);
                world.setThundering(true);
                MessageBuilder.sign("Weather.WeatherSet", user).postModifier(message -> message.replace("<WEATHER>", "thunder")).build();
                yield true;
            }
            default -> {
                MessageBuilder.sign("Weather.InvalidWeather", user).postModifier(message -> message.replace("<WEATHER>", finalWeatherType)).build();
                yield false;
            }
        };
    }
}

