/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.weather;

import me.testaccount666.serversystem.clickablesigns.AbstractSignConfigurator;
import me.testaccount666.serversystem.clickablesigns.SignType;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfiguratorWeatherSign
extends AbstractSignConfigurator {
    @Override
    protected String getCreatePermissionNode() {
        return "ClickableSigns.Weather.Create";
    }

    @Override
    protected SignType getSignType() {
        return SignType.WEATHER;
    }

    @Override
    protected boolean validateConfiguration(User user, Sign sign, YamlConfiguration config) {
        SignSide front = sign.getSide(Side.FRONT);
        String weatherType = front.getLine(1).toLowerCase();
        if (weatherType.isEmpty()) {
            MessageBuilder.sign("Weather.NoWeatherSpecified", user).build();
            return false;
        }
        if (!this.isValidWeatherType(weatherType)) {
            MessageBuilder.sign("Weather.InvalidWeather", user).postModifier(message -> message.replace("<WEATHER>", weatherType)).build();
            return false;
        }
        front.line(0, ComponentColor.translateToComponent(SignType.WEATHER.signName()));
        front.line(1, ComponentColor.translateToComponent("&2" + weatherType));
        SignSide back = sign.getSide(Side.BACK);
        for (int index = 0; index < 4; ++index) {
            back.line(index, front.line(index));
        }
        sign.update();
        return true;
    }

    @Override
    protected void addSignSpecificConfiguration(User user, Sign sign, FileConfiguration config) {
        String weatherType = sign.getSide(Side.FRONT).getLine(1).toLowerCase();
        weatherType = ChatColor.stripColor(weatherType);
        config.set("WeatherType", (Object)weatherType);
    }

    @Override
    protected String getSuccessMessageKey() {
        return "Weather.Created";
    }

    private boolean isValidWeatherType(String weatherType) {
        return weatherType.equals("sun") || weatherType.equals("clear") || weatherType.equals("storm") || weatherType.equals("thunder") || weatherType.equals("rain");
    }
}

