/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

public abstract class AbstractServerSystemCommand
implements ServerSystemCommandExecutor {
    protected Optional<User> getTargetUser(User commandSender, String ... arguments) {
        return this.getTargetUser(commandSender, true, arguments);
    }

    protected Optional<User> getTargetUser(User commandSender, boolean returnSender, String ... arguments) {
        return this.getTargetUser(commandSender, 0, returnSender, arguments);
    }

    protected Optional<User> getTargetUser(User commandSender, int index, String ... arguments) {
        return this.getTargetUser(commandSender, index, true, arguments);
    }

    protected Optional<User> getTargetUser(User commandSender, int index, boolean returnSender, String ... arguments) {
        if (arguments.length > index) {
            Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(arguments[index], true);
            return userOptional.map(user -> (User)user.getOfflineUser());
        }
        return returnSender ? Optional.of(commandSender) : Optional.empty();
    }

    protected boolean handleConsoleWithNoTarget(User commandSender, String syntaxPath, String label, String ... arguments) {
        return this.handleConsoleWithNoTarget(commandSender, syntaxPath, label, 0, arguments);
    }

    protected boolean handleConsoleWithNoTarget(User commandSender, String syntaxPath, String label, int expectedLength, String ... arguments) {
        if (arguments.length <= expectedLength && commandSender instanceof ConsoleUser) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(syntaxPath).label(label).build();
            return true;
        }
        return false;
    }

    protected boolean checkBasePermission(User commandSender, String permission) {
        return this.checkOtherPermission(commandSender, permission, null);
    }

    protected boolean checkOtherPermission(User commandSender, String permission, String targetName) {
        if (!PermissionManager.hasCommandPermission(commandSender, permission)) {
            this.sendNoPermissionMessage(commandSender, "Commands." + permission, targetName);
            return false;
        }
        return true;
    }

    protected void sendNoPermissionMessage(User recipient, String permission, String targetName) {
        MessageBuilder.general("NoPermission", recipient).postModifier(message -> message.replace("<PERMISSION>", PermissionManager.getPermission(permission))).target(targetName).build();
    }

    public abstract String getSyntaxPath(Command var1);

    public abstract boolean hasCommandAccess(Player var1, Command var2);
}

