/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.back;

import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.back.CommandBack;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@RequiredCommands(requiredCommands={CommandBack.class})
public class ListenerBack
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        return requiredCommands.stream().anyMatch(CommandBack.class::isInstance);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(event.getPlayer());
        if (userOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = userOptional.get();
        OfflineUser user = cachedUser.getOfflineUser();
        user.setLastTeleportLocation(event.getFrom());
        user.setLastBackType(CommandBack.BackType.TELEPORT);
        user.save();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(event.getEntity());
        if (userOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = userOptional.get();
        OfflineUser user = cachedUser.getOfflineUser();
        user.setLastDeathLocation(event.getPlayer().getLocation());
        user.setLastBackType(CommandBack.BackType.DEATH);
        user.save();
    }
}

