/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.balance;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="balance", variants={"baltop"})
public class CommandBalance
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().equalsIgnoreCase("baltop")) {
            this.executeBaltop(commandSender);
            return;
        }
        this.executeBalance(commandSender, command, label, arguments);
    }

    private void executeBaltop(User commandSender) {
        if (!this.checkBasePermission(commandSender, "Baltop.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        AbstractBankAccount bankAccount = commandSender.getBankAccount();
        Map<UUID, BigDecimal> topTen = bankAccount.getTopTen();
        if (topTen.isEmpty()) {
            MessageBuilder.command("Baltop.NoData", commandSender).build();
            return;
        }
        MessageBuilder.command("Baltop.Header", commandSender).prefix(false).build();
        int position = 1;
        for (Map.Entry<UUID, BigDecimal> entry : topTen.entrySet()) {
            UUID playerUuid = entry.getKey();
            BigDecimal balance = entry.getValue();
            String formattedBalance = ServerSystem.Instance.getRegistry().getService(EconomyProvider.class).formatMoney(balance);
            String playerName = Bukkit.getOfflinePlayer((UUID)playerUuid).getName();
            playerName = playerName != null ? playerName : "Unknown";
            int currentPosition = position++;
            MessageBuilder.command("Baltop.Entry", commandSender).prefix(false).target(playerName).postModifier(message -> message.replace("<POSITION>", String.valueOf(currentPosition)).replace("<BALANCE>", formattedBalance)).build();
        }
    }

    private void executeBalance(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Balance.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Balance.Other", targetPlayer.getName())) {
            return;
        }
        BigDecimal balance = targetUser.getBankAccount().getBalance();
        String formattedBalance = ServerSystem.Instance.getRegistry().getService(EconomyProvider.class).formatMoney(balance);
        String messagePath = isSelf ? "Balance.Success" : "Balance.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<BALANCE>", formattedBalance)).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Balance";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Balance.Use", false);
    }
}

