/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.broadcast;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="broadcast")
public class CommandBroadcast
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Broadcast.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String broadcast = ChatColor.translateColor(String.join((CharSequence)" ", arguments).trim());
        Optional<String> messageFormatOptional = MessageBuilder.command("Broadcast.Format", commandSender).target("*").prefix(false).send(false).postModifier(message -> message.replace("<BROADCAST>", broadcast)).build();
        if (messageFormatOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).target("*").build();
            return;
        }
        String messageFormat = messageFormatOptional.get();
        Bukkit.broadcastMessage((String)messageFormat);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Broadcast";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Broadcast.Use", false);
    }
}

