/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.disposal;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

@ServerSystemCommand(name="disposal")
public class CommandDisposal
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Disposal.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Disposal.Other", targetPlayer.getName())) {
            return;
        }
        targetPlayer.openInventory(Bukkit.createInventory((InventoryHolder)targetPlayer, (int)(InventoryType.CHEST.getDefaultSize() * 2), (String)"\u00a7cTrash"));
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Disposal.Success", targetUser).target(targetPlayer.getName()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Disposal";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Disposal.Use", false);
    }
}

