/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.enderchest.offline;

import de.tr7zw.nbtapi.NBT;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.enderchest.offline.EnderChestLoader;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CommandOfflineEnderChest
extends AbstractServerSystemCommand {
    public final EnderChestLoader enderChestLoader;

    public CommandOfflineEnderChest() {
        if (!Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            ServerSystem.getLog().warning("NBTAPI is not installed, Offline-EnderChest will not work!");
            this.enderChestLoader = null;
            return;
        }
        if (!NBT.preloadApi()) {
            ServerSystem.getLog().severe("Failed to load NBT-API!");
            this.enderChestLoader = null;
            return;
        }
        this.enderChestLoader = new EnderChestLoader();
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length < 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        this.executeEnderChestCommand(commandSender, arguments);
    }

    public void executeEnderChestCommand(User commandSender, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "OfflineEnderChest.Use")) {
            return;
        }
        Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(arguments[0]);
        if (cachedUserOptional.isEmpty()) {
            MessageBuilder.general("Offline.NeverPlayed", commandSender).target(arguments[0]).build();
            return;
        }
        CachedUser cachedUser = cachedUserOptional.get();
        if (cachedUser.isOnlineUser()) {
            MessageBuilder.general("Offline.NotOffline", commandSender).target(arguments[0]).build();
            return;
        }
        OfflineUser targetUser = cachedUser.getOfflineUser();
        OfflinePlayer targetPlayer = targetUser.getPlayer();
        if (!targetPlayer.hasPlayedBefore()) {
            MessageBuilder.general("Offline.NeverPlayed", commandSender).target(arguments[0]).build();
            return;
        }
        Optional<Inventory> inventoryOptional = this.enderChestLoader.loadOfflineInventory(targetPlayer);
        if (inventoryOptional.isEmpty()) {
            ServerSystem.getLog().warning("(OfflineEnderChest) Failed to load inventory of '" + arguments[0] + "'!");
            MessageBuilder.general("ErrorOccurred", commandSender).target(arguments[0]).build();
            return;
        }
        Inventory inventory = inventoryOptional.get();
        commandSender.getPlayer().openInventory(inventory);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "OfflineEnderChest";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "OfflineEnderChest.Use", false);
    }
}

