/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.enderchest.offline;

import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.iface.NBTFileHandle;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBTCompoundList;
import de.tr7zw.nbtapi.iface.ReadableNBT;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.utils.BiDirectionalHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EnderChestLoader {
    public final BiDirectionalHashMap<UUID, Inventory> inventoryMap = new BiDirectionalHashMap();

    public Optional<Inventory> loadOfflineInventory(OfflinePlayer offlinePlayer) {
        if (!offlinePlayer.hasPlayedBefore()) {
            return Optional.empty();
        }
        UUID playerUUID = offlinePlayer.getUniqueId();
        if (this.inventoryMap.containsKey(playerUUID)) {
            return this.inventoryMap.getValue(playerUUID);
        }
        File playerDataFile = Path.of(((World)Bukkit.getWorlds().getFirst()).getWorldFolder().getPath(), "playerdata", String.valueOf(playerUUID) + ".dat").toFile();
        if (!playerDataFile.exists()) {
            ServerSystem.getLog().warning("Player data file not found for " + offlinePlayer.getName() + " (" + String.valueOf(offlinePlayer.getUniqueId()) + ")");
            return Optional.empty();
        }
        try {
            NBTFileHandle fileHandle = NBT.getFileHandle((File)playerDataFile);
            ReadWriteNBTCompoundList enderItemsTag = fileHandle.getCompoundList("EnderItems");
            if (enderItemsTag == null) {
                return Optional.empty();
            }
            Inventory inventory = Bukkit.createInventory(null, (int)27, (String)(offlinePlayer.getName() + "'s Ender Chest"));
            for (int index = 0; index < enderItemsTag.size(); ++index) {
                ReadWriteNBT itemTag = (ReadWriteNBT)enderItemsTag.get(index);
                if (itemTag == null) continue;
                Byte slot = itemTag.getByte("Slot");
                ItemStack itemStack = NBT.itemStackFromNBT((ReadableNBT)itemTag);
                inventory.setItem((int)slot.byteValue(), itemStack);
            }
            this.inventoryMap.put(playerUUID, inventory);
            return Optional.of(inventory);
        }
        catch (IOException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to load ender chest for " + offlinePlayer.getName() + " (" + String.valueOf(offlinePlayer.getUniqueId()) + ")", exception);
            return Optional.empty();
        }
    }

    public void saveOfflineInventory(UUID playerUUID, Inventory inventory) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUUID);
        File playerDataFile = Path.of(((World)Bukkit.getWorlds().getFirst()).getWorldFolder().getPath(), "playerdata", String.valueOf(playerUUID) + ".dat").toFile();
        if (!playerDataFile.exists()) {
            ServerSystem.getLog().warning("Player data file not found for " + offlinePlayer.getName() + " (" + String.valueOf(offlinePlayer.getUniqueId()) + ")");
            return;
        }
        try {
            NBTFileHandle fileHandle = NBT.getFileHandle((File)playerDataFile);
            ReadWriteNBTCompoundList enderItemsTag = fileHandle.getCompoundList("EnderItems");
            if (enderItemsTag == null) {
                return;
            }
            enderItemsTag.clear();
            for (int slot = 0; slot < 27; ++slot) {
                ItemStack item = inventory.getItem(slot);
                if (item == null || item.getType().isAir()) continue;
                ReadWriteNBT itemTag = NBT.itemStackToNBT((ItemStack)item);
                itemTag.setByte("Slot", Byte.valueOf((byte)slot));
                enderItemsTag.addCompound((ReadableNBT)itemTag);
            }
            fileHandle.save();
            ServerSystem.getLog().info("Saved ender chest for " + offlinePlayer.getName() + " (" + String.valueOf(offlinePlayer.getUniqueId()) + ")");
        }
        catch (IOException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to save ender chest for " + offlinePlayer.getName() + " (" + String.valueOf(offlinePlayer.getUniqueId()) + ")", exception);
        }
    }
}

