/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.enderchest.offline;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.enderchest.CommandEnderChest;
import me.testaccount666.serversystem.commands.executables.enderchest.offline.EnderChestLoader;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

@RequiredCommands(requiredCommands={CommandEnderChest.class})
public class ListenerOfflineEnderChest
implements Listener {
    private EnderChestLoader _enderChestLoader;
    private CommandEnderChest _enderChest;

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandEnderChest)) {
                return;
            }
            CommandEnderChest commandEnderChest = (CommandEnderChest)command;
            EnderChestLoader enderChestLoader = commandEnderChest.offlineEnderChest.enderChestLoader;
            if (enderChestLoader == null) {
                return;
            }
            this._enderChest = commandEnderChest;
            this._enderChestLoader = enderChestLoader;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onViewedJoin(PlayerLoginEvent event) {
        Player viewedPlayer = event.getPlayer();
        Optional<Inventory> inventoryOptional = this._enderChestLoader.inventoryMap.getValue(viewedPlayer.getUniqueId());
        if (inventoryOptional.isEmpty()) {
            ServerSystem.getLog().fine("OfflineEnderChest: No offline inventory found for player " + viewedPlayer.getName());
            return;
        }
        Inventory inventory = inventoryOptional.get();
        ServerSystem.getLog().fine("OfflineEnderChest: Offline inventory was found for player " + viewedPlayer.getName());
        ArrayList viewers = new ArrayList(inventory.getViewers());
        inventory.close();
        this._enderChestLoader.inventoryMap.removeByKey(viewedPlayer.getUniqueId());
        this._enderChestLoader.saveOfflineInventory(viewedPlayer.getUniqueId(), inventory);
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> viewers.forEach(viewer -> {
            if (!(viewer instanceof Player)) {
                return;
            }
            Player player = (Player)viewer;
            Optional<CachedUser> optionalUser = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(player);
            if (optionalUser.isEmpty()) {
                return;
            }
            CachedUser cachedUser = optionalUser.get();
            if (cachedUser.isOfflineUser()) {
                return;
            }
            User user = (User)cachedUser.getOfflineUser();
            this._enderChest.executeEnderChestCommand(user, viewedPlayer.getName());
        }), 10L);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        if (!this._enderChestLoader.inventoryMap.containsValue(inventory)) {
            return;
        }
        Optional<UUID> uuid = this._enderChestLoader.inventoryMap.getKey(inventory);
        if (uuid.isEmpty()) {
            return;
        }
        this._enderChestLoader.inventoryMap.removeByValue(inventory);
        this._enderChestLoader.saveOfflineInventory(uuid.get(), inventory);
    }
}

