/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.god;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="god")
public class CommandGod
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "God.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "God.Other", targetPlayer.getName())) {
            return;
        }
        boolean isGod = !targetUser.isGodMode();
        Object messagePath = isSelf ? "God.Success" : "God.SuccessOther";
        messagePath = isGod ? (String)messagePath + ".Enabled" : (String)messagePath + ".Disabled";
        targetUser.setGodMode(isGod);
        targetUser.save();
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("God.Success." + (isGod ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).target(targetPlayer.getName()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "God";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "God.Use", false);
    }
}

