/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.hat;

import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@ServerSystemCommand(name="hat")
public class CommandHat
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Hat.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        PlayerInventory inventory = commandSender.getPlayer().getInventory();
        ItemStack itemInHand = inventory.getItemInMainHand();
        ItemStack itemOnHead = inventory.getHelmet();
        if (itemOnHead == null) {
            itemOnHead = ItemStack.empty();
        }
        if (itemInHand.isEmpty() && itemOnHead.isEmpty()) {
            MessageBuilder.command("Hat.NoHat", commandSender).build();
            return;
        }
        if (itemInHand.isEmpty() && !itemOnHead.isEmpty()) {
            inventory.setHelmet(ItemStack.empty());
            inventory.setItemInMainHand(itemOnHead);
            MessageBuilder.command("Hat.RemovedHat", commandSender).build();
            return;
        }
        if (!itemInHand.isEmpty() && !itemOnHead.isEmpty()) {
            MessageBuilder.command("Hat.AlreadyHasHat", commandSender).build();
            return;
        }
        inventory.setHelmet(itemInHand);
        inventory.setItemInMainHand(ItemStack.empty());
        MessageBuilder.command("Hat.AppliedHat", commandSender).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        throw new UnsupportedOperationException("Hat command doesn't have an available syntax!");
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Hat.Use", false);
    }
}

