/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.home.admin;

import java.util.Optional;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandAdminHome
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String commandName = command.getName().substring("admin".length());
        if (commandName.equalsIgnoreCase("sethome")) {
            this.handleSetHomeCommand(commandSender, command, label, arguments);
            return;
        }
        if (commandName.equalsIgnoreCase("deletehome")) {
            this.handleDeleteHomeCommand(commandSender, command, label, arguments);
            return;
        }
        this.handleHomeCommand(commandSender, command, label, arguments);
    }

    private void handleHomeCommand(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "AdminHome.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        HomeManager homeManager = targetUser.getHomeManager();
        Optional<Home> homeOptional = homeManager.getHomeByName(arguments[1]);
        if (homeOptional.isEmpty()) {
            MessageBuilder.command("Home.DoesNotExist", targetUser).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", arguments[1])).build();
            return;
        }
        Home home = homeOptional.get();
        Location homeLocation = home.getLocation();
        commandSender.getPlayer().teleport(homeLocation);
        MessageBuilder.command("Home.Success", targetUser).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", home.getDisplayName())).build();
    }

    private void handleDeleteHomeCommand(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "AdminHome.Delete")) {
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        HomeManager homeManager = targetUser.getHomeManager();
        Optional<Home> homeOptional = homeManager.getHomeByName(arguments[1]);
        if (homeOptional.isEmpty()) {
            MessageBuilder.general("Home.DoesNotExist", commandSender).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", arguments[1])).build();
            return;
        }
        Home home = homeOptional.get();
        homeManager.removeHome(home);
        MessageBuilder.general("DeleteHome.Success", commandSender).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", home.getDisplayName())).build();
    }

    private void handleSetHomeCommand(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "AdminHome.Set")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        HomeManager homeManager = targetUser.getHomeManager();
        Optional<Integer> maxHomesOptional = homeManager.getMaxHomeCount();
        if (maxHomesOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", targetUser).label(label).build();
            return;
        }
        String homeName = arguments[1];
        if (homeManager.hasHome(homeName)) {
            MessageBuilder.command("SetHome.AlreadyExists", targetUser).label(label).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", homeName)).build();
            return;
        }
        Optional<Home> newHomeOptional = Home.of(homeName, commandSender.getPlayer().getLocation());
        if (newHomeOptional.isEmpty()) {
            MessageBuilder.command("SetHome.InvalidName", commandSender).label(label).target(targetUser.getName().get()).build();
            return;
        }
        Home newHome = newHomeOptional.get();
        homeManager.addHome(newHome);
        MessageBuilder.command("SetHome.Success", targetUser).label(label).target(targetUser.getName().get()).postModifier(message -> message.replace("<HOME>", newHome.getDisplayName())).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "AdminHome";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String commandName = command.getName().substring("admin".length());
        if (commandName.equalsIgnoreCase("sethome")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "AdminHome.Set", false);
        }
        if (commandName.equalsIgnoreCase("deletehome")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "AdminHome.Delete", false);
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, "AdminHome.Use", false);
    }
}

