/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.home.admin;

import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import org.bukkit.command.Command;

public class TabCompleterAdminHome
implements ServerSystemTabCompleter {
    @Override
    public Optional<List<String>> tabComplete(User commandSender, Command command, String label, String ... arguments) {
        String commandName = command.getName().substring("admin".length());
        if (commandName.equalsIgnoreCase("sethome")) {
            return this.handleSetHomeCommand(commandSender, arguments);
        }
        if (commandName.equalsIgnoreCase("deletehome")) {
            return this.handleDeleteHomeCommand(commandSender, arguments);
        }
        return this.handleHomeCommand(commandSender, arguments);
    }

    private Optional<List<String>> handleHomeCommand(User commandSender, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "AdminHome.Use", false)) {
            return Optional.empty();
        }
        if (arguments.length <= 1) {
            return Optional.empty();
        }
        return this.handleHomeCompletion(commandSender, arguments);
    }

    private Optional<List<String>> handleSetHomeCommand(User commandSender, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "AdminSetHome.Use", false)) {
            return Optional.empty();
        }
        if (arguments.length <= 1) {
            return Optional.empty();
        }
        return Optional.of(List.of());
    }

    private Optional<List<String>> handleDeleteHomeCommand(User commandSender, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "AdminDeleteHome.Use", false)) {
            return Optional.empty();
        }
        if (arguments.length <= 1) {
            return Optional.empty();
        }
        return this.handleHomeCompletion(commandSender, arguments);
    }

    private Optional<List<String>> handleHomeCompletion(OfflineUser commandSender, String ... arguments) {
        if (arguments.length != 2) {
            return Optional.of(List.of());
        }
        Optional<CachedUser> targetUserOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(arguments[0]);
        if (targetUserOptional.isEmpty()) {
            return Optional.of(List.of());
        }
        CachedUser targetCachedUser = targetUserOptional.get();
        OfflineUser targetUser = targetCachedUser.getOfflineUser();
        HomeManager homeManager = targetUser.getHomeManager();
        List<String> potentialCompletions = homeManager.getHomes().stream().map(Home::getDisplayName).toList();
        List<String> foundCompletions = potentialCompletions.stream().filter(completion -> completion.toLowerCase().startsWith(arguments[1].toLowerCase())).toList();
        return Optional.of(foundCompletions);
    }
}

