/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.inventorysee.offline;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.inventorysee.offline.InventoryLoader;
import me.testaccount666.serversystem.commands.executables.inventorysee.online.CommandInventorySee;
import me.testaccount666.serversystem.commands.executables.inventorysee.utils.AbstractInventorySeeListener;
import me.testaccount666.serversystem.commands.executables.inventorysee.utils.InventorySeeUtils;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.BiDirectionalHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.Inventory;

@RequiredCommands(requiredCommands={CommandInventorySee.class})
public class ListenerOfflineInventorySee
extends AbstractInventorySeeListener
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> commands) {
        return this.internalCanRegister(commands);
    }

    @Override
    protected boolean additionalRegistrationChecks() {
        return this._commandInventorySee.offlineInventorySee.inventoryLoader != null;
    }

    @EventHandler
    public void onPlayerJoin(PlayerLoginEvent event) {
        InventoryLoader inventoryLoader = this._commandInventorySee.offlineInventorySee.inventoryLoader;
        BiDirectionalHashMap<UUID, Inventory> inventoryMap = inventoryLoader.inventoryMap;
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Optional<Inventory> inventoryOptional = inventoryMap.getValue(uuid);
        if (inventoryOptional.isEmpty()) {
            return;
        }
        Inventory inventory = inventoryOptional.get();
        inventoryMap.removeByKey(uuid);
        inventoryLoader.saveOfflineInventory(uuid, inventory);
        InventorySeeUtils.handleInventoryViewers(inventory, player, 10L, (user, playerName) -> this._commandInventorySee.processInventorySee((User)user, "", (String)playerName));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryLoader inventoryLoader = this._commandInventorySee.offlineInventorySee.inventoryLoader;
        BiDirectionalHashMap<UUID, Inventory> inventoryMap = inventoryLoader.inventoryMap;
        Inventory inventory = event.getInventory();
        Optional<UUID> uuidOptional = inventoryMap.getKey(inventory);
        if (uuidOptional.isEmpty()) {
            return;
        }
        UUID uuid = uuidOptional.get();
        inventoryMap.removeByKey(uuid);
        inventoryLoader.saveOfflineInventory(uuid, inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryLoader inventoryLoader = this._commandInventorySee.offlineInventorySee.inventoryLoader;
        BiDirectionalHashMap<UUID, Inventory> inventoryMap = inventoryLoader.inventoryMap;
        Inventory inventory = event.getInventory();
        if (!inventoryMap.containsValue(inventory)) {
            return;
        }
        if (event.getRawSlot() < 41 || event.getRawSlot() >= 54) {
            return;
        }
        event.setCancelled(true);
    }
}

