/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.inventorysee.online;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.inventorysee.offline.CommandOfflineInventorySee;
import me.testaccount666.serversystem.commands.executables.inventorysee.online.TabCompleterInventorySee;
import me.testaccount666.serversystem.commands.executables.inventorysee.utils.InventorySeeUtils;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

@ServerSystemCommand(name="inventorysee", variants={"offlineinventorysee"}, tabCompleter=TabCompleterInventorySee.class)
public class CommandInventorySee
extends AbstractServerSystemCommand {
    public final Map<Player, Inventory> inventoryCache = new HashMap<Player, Inventory>();
    public final CommandOfflineInventorySee offlineInventorySee = new CommandOfflineInventorySee(this);

    @Override
    public void execute(User sender, Command command, String label, String ... arguments) {
        if (command.getName().toLowerCase().startsWith("offline")) {
            this.offlineInventorySee.execute(sender, command, label, arguments);
            return;
        }
        if (!command.getName().equalsIgnoreCase("inventorysee")) {
            return;
        }
        this.processInventorySee(sender, label, arguments);
    }

    public void processInventorySee(User sender, String label, String ... arguments) {
        if (!this.checkBasePermission(sender, "InventorySee.Use")) {
            return;
        }
        if (sender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", sender).build();
            return;
        }
        if (arguments.length < 1) {
            MessageBuilder.general("InvalidArguments", sender).syntax(this.getSyntaxPath(null)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(sender, arguments[0]);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", sender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        if (targetUser == sender) {
            MessageBuilder.command("InventorySee.CannotSeeSelf", sender).build();
            return;
        }
        Player ownerPlayer = targetUser.getPlayer();
        Player viewerPlayer = sender.getPlayer();
        Inventory customInventory = this.inventoryCache.computeIfAbsent(ownerPlayer, this::createAndInitializeInventory);
        viewerPlayer.openInventory(customInventory);
    }

    private Inventory createAndInitializeInventory(Player ownerPlayer) {
        Inventory newInventory = Bukkit.createInventory((InventoryHolder)ownerPlayer, (int)54, (String)(ownerPlayer.getName() + "'s Inventory"));
        this.refreshInventoryContents(ownerPlayer, newInventory);
        return newInventory;
    }

    protected void refreshInventoryContents(Player owner, Inventory displayInventory) {
        this.copyPlayerInventory(owner, displayInventory);
        this.addSectionDecorators(displayInventory);
    }

    private void copyPlayerInventory(Player owner, Inventory displayInventory) {
        for (int slot = 0; slot < 40; ++slot) {
            displayInventory.setItem(slot, owner.getInventory().getItem(slot));
        }
        displayInventory.setItem(40, owner.getInventory().getItemInOffHand());
        displayInventory.setItem(41, owner.getOpenInventory().getCursor());
    }

    public void addSectionDecorators(Inventory displayInventory) {
        InventorySeeUtils.addSectionDecorators(displayInventory, false);
    }

    public void placeFilledMarkers(Inventory inventory, Material material, String displayName, int startSlot, int endSlot) {
        InventorySeeUtils.placeFilledMarkers(inventory, material, displayName, startSlot, endSlot);
    }

    protected void applyChangesToOwner(Player owner, Inventory displayInventory) {
        for (int slot = 0; slot < 40; ++slot) {
            owner.getInventory().setItem(slot, displayInventory.getItem(slot));
        }
        owner.getInventory().setItemInOffHand(displayInventory.getItem(40));
        owner.setItemOnCursor(displayInventory.getItem(41));
        owner.updateInventory();
        this.dropModifiedItems(owner, displayInventory, 42, 45);
    }

    private void dropModifiedItems(Player owner, Inventory displayInventory, int fromSlot, int toSlot) {
        for (int slot = fromSlot; slot < toSlot; ++slot) {
            ItemStack item = displayInventory.getItem(slot);
            if (item == null) continue;
            owner.getWorld().dropItem(owner.getEyeLocation().add(0.0, -0.33, 0.0), item.clone()).setVelocity(owner.getLocation().getDirection().multiply(0.35));
            item.setAmount(0);
        }
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "InventorySee";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        if (command.getName().toLowerCase().startsWith("offline")) {
            return this.offlineInventorySee.hasCommandAccess(player, command);
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, "InventorySee.Use", false);
    }
}

