/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.inventorysee.online;

import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.inventorysee.online.CommandInventorySee;
import me.testaccount666.serversystem.commands.executables.inventorysee.utils.AbstractInventorySeeListener;
import me.testaccount666.serversystem.commands.executables.inventorysee.utils.InventorySeeUtils;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

@RequiredCommands(requiredCommands={CommandInventorySee.class})
public class ListenerInventorySee
extends AbstractInventorySeeListener
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> commands) {
        return this.internalCanRegister(commands);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onViewerClick(InventoryClickEvent event) {
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Inventory bottomInventory = event.getView().getBottomInventory();
        Player viewerPlayer = (Player)event.getWhoClicked();
        Player owner = this.findInventoryOwner(topInventory, bottomInventory);
        if (owner == null || owner == viewerPlayer) {
            return;
        }
        Inventory cachedInventory = this._commandInventorySee.inventoryCache.get(owner);
        if (cachedInventory == null || cachedInventory != topInventory && cachedInventory != bottomInventory) {
            return;
        }
        if (!PermissionManager.hasCommandPermission((CommandSender)viewerPlayer, "InventorySee.Modify", false) || event.getRawSlot() > 44 && event.getRawSlot() < 54) {
            event.setCancelled(true);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> this._commandInventorySee.applyChangesToOwner(owner, cachedInventory), 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onOwnerInventoryChange(PlayerDropItemEvent event) {
        this.updateCachedInventory(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onOwnerInventoryChange(PlayerPickupItemEvent event) {
        this.updateCachedInventory(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onOwnerInventoryChange(PlayerSwapHandItemsEvent event) {
        this.updateCachedInventory(event.getPlayer());
    }

    @EventHandler
    public void onGeneralClick(InventoryClickEvent event) {
        Player viewerPlayer = (Player)event.getWhoClicked();
        this.updateCachedInventory(viewerPlayer);
    }

    private Player findInventoryOwner(Inventory topInventory, Inventory bottomInventory) {
        InventoryHolder holder = topInventory.getHolder();
        if (holder instanceof Player) {
            Player player = (Player)holder;
            return player;
        }
        holder = bottomInventory.getHolder();
        if (holder instanceof Player) {
            Player player = (Player)holder;
            return player;
        }
        return null;
    }

    private void updateCachedInventory(Player player) {
        Inventory cachedInventory = this._commandInventorySee.inventoryCache.get(player);
        if (cachedInventory == null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> this._commandInventorySee.refreshInventoryContents(player, cachedInventory), 1L);
    }

    @EventHandler
    public void onViewedQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this._commandInventorySee.inventoryCache.containsKey(player)) {
            return;
        }
        Inventory inventory = this._commandInventorySee.inventoryCache.get(player);
        this._commandInventorySee.inventoryCache.remove(player);
        InventorySeeUtils.handleInventoryViewers(inventory, player, 10L, (user, playerName) -> this._commandInventorySee.offlineInventorySee.processOfflineInventorySee((User)user, "", (String)playerName));
    }
}

