/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.ip;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="ip")
public class CommandIp
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Ip.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        MessageBuilder.command("Ip.Success", commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<IP>", targetPlayer.getAddress().getAddress().getHostAddress())).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Ip";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Ip.Use", false);
    }
}

