/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.moderation.ban;

import io.papermc.paper.ban.BanListType;
import java.time.Instant;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.moderation.AbstractModerationCommand;
import me.testaccount666.serversystem.commands.executables.moderation.TabCompleterModeration;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.BanModeration;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="ban", variants={"unban"}, tabCompleter=TabCompleterModeration.class)
public class CommandBan
extends AbstractModerationCommand {
    @Override
    protected void handlePostModeration(Command command, User commandSender, OfflineUser targetUser, AbstractModeration moderation) {
        if (!(targetUser instanceof User)) {
            return;
        }
        User user = (User)targetUser;
        Player player = user.getPlayer();
        String unbanDate = DurationParser.parseDate(moderation.expireTime(), targetUser);
        Optional<String> kickOptional = MessageBuilder.command("Moderation.Ban.Kick", user).sender(commandSender.getName().get()).send(false).target(user.getName().get()).prefix(false).postModifier(message -> message.replace("<DATE>", unbanDate).replace("<REASON>", moderation.reason())).build();
        if (kickOptional.isEmpty()) {
            ServerSystem.getLog().severe("(CommandBan) Kick message is empty! This should not happen!");
            MessageBuilder.general("ErrorOccurred", commandSender).build();
            return;
        }
        long expireTime = moderation.expireTime();
        if (expireTime == 0L) {
            expireTime = Instant.now().toEpochMilli() + 1L;
        }
        Instant unbanTime = expireTime > 0L ? Instant.ofEpochMilli(expireTime) : null;
        player.ban(kickOptional.get(), unbanTime, moderation.senderUuid().toString(), true);
    }

    @Override
    protected void handlePostRemoveModeration(Command command, User commandSender, OfflineUser targetUser) {
        ((ProfileBanList)Bukkit.getServer().getBanList(BanListType.PROFILE)).pardon((Object)targetUser.getPlayer().getPlayerProfile());
    }

    @Override
    protected AbstractModeration createModeration(Command command, User commandSender, OfflineUser targetUser, long expireTime, String reason) {
        return ((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)((BanModeration.BanModerationBuilder)BanModeration.builder().senderUuid(commandSender.getUuid())).targetUuid(targetUser.getUuid())).reason(reason)).expireTime(expireTime)).build();
    }

    @Override
    protected boolean checkBasePermission(User commandSender, Command command) {
        String permissionPath = switch (command.getName().toLowerCase()) {
            case "ban" -> "Moderation.Ban.Use";
            case "unban" -> "Moderation.Ban.Remove";
            default -> null;
        };
        return this.checkBasePermission(commandSender, permissionPath);
    }

    @Override
    protected AbstractModerationManager getModerationManager(OfflineUser targetUser) {
        return targetUser.getBanManager();
    }

    @Override
    protected String type(Command command) {
        return "Ban";
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "ban" -> "Ban";
            case "unban" -> "Unban";
            default -> throw new IllegalArgumentException("(CommandBan) Unknown command name: " + commandName);
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath = switch (command.getName().toLowerCase()) {
            case "ban" -> "Moderation.Ban.Use";
            case "unban" -> "Moderation.Ban.Remove";
            default -> null;
        };
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }
}

