/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.moderation.kick;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="kick")
public class CommandKick
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Moderation.Kick.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Optional<String> defaultReason = MessageBuilder.command("Moderation.DefaultReason", commandSender).target(targetUser.getName().get()).prefix(false).send(false).build();
        if (defaultReason.isEmpty()) {
            ServerSystem.getLog().severe("(CommandKick) Default reason is empty! This should not happen!");
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        String reason = defaultReason.get();
        if (arguments.length > 1) {
            reason = IntStream.range(1, arguments.length).mapToObj(index -> arguments[index] + " ").collect(Collectors.joining()).trim();
        }
        String finalReason = reason;
        Optional<String> kickOptional = MessageBuilder.command("Moderation.Kick.Kick", commandSender).target(targetUser.getName().get()).prefix(false).postModifier(message -> message.replace("<REASON>", finalReason)).send(false).build();
        if (kickOptional.isEmpty()) {
            ServerSystem.getLog().severe("(CommandBan) Kick message is empty! This should not happen!");
            MessageBuilder.general("ErrorOccurred", commandSender).build();
            return;
        }
        targetUser.getPlayer().kickPlayer(kickOptional.get());
        MessageBuilder.command("Moderation.Kick.Success", commandSender).target(targetUser.getName().get()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Kick";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Moderation.Kick.Use", false);
    }
}

