/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.ping;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="ping")
public class CommandPing
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Ping.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Ping.Other", targetPlayer.getName())) {
            return;
        }
        String messagePath = isSelf ? "Ping.Success" : "Ping.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<PING>", targetPlayer.getPing() + "ms")).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Ping";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Ping.Use", false);
    }
}

