/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.rename;

import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@ServerSystemCommand(name="rename")
public class CommandRename
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Rename.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Player player = commandSender.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.isEmpty()) {
            MessageBuilder.command("Rename.NoItemInHand", commandSender).build();
            return;
        }
        String newName = String.join((CharSequence)" ", arguments).trim();
        ItemMeta itemMeta = itemInHand.getItemMeta();
        itemMeta.itemName(ComponentColor.translateToComponent(newName));
        itemInHand.setItemMeta(itemMeta);
        MessageBuilder.command("Rename.Success", commandSender).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Rename";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Rename.Use", false);
    }
}

