/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.repair;

import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.repair.TabCompleterRepair;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

@ServerSystemCommand(name="repair", tabCompleter=TabCompleterRepair.class)
public class CommandRepair
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Repair.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        String repairType = arguments.length == 0 ? "hand" : arguments[0].toLowerCase();
        Player player = commandSender.getPlayer();
        switch (repairType) {
            case "all": 
            case "*": {
                int repaired = 0;
                repaired += this.repairInventory(player.getInventory().getContents());
                repaired += this.repairInventory(player.getInventory().getArmorContents());
                this.sendSuccessMessage(commandSender, repaired += this.repairInventory(player.getInventory().getExtraContents()));
                break;
            }
            case "hand": {
                ItemStack item = player.getInventory().getItemInMainHand();
                if (this.repairItem(item)) {
                    this.sendSuccessMessage(commandSender, 1);
                    break;
                }
                MessageBuilder.command("Repair.NotRepairable", commandSender).build();
                break;
            }
            case "offhand": {
                ItemStack item = player.getInventory().getItemInOffHand();
                if (this.repairItem(item)) {
                    this.sendSuccessMessage(commandSender, 1);
                    break;
                }
                MessageBuilder.command("Repair.NotRepairable", commandSender).build();
                break;
            }
            case "armor": {
                int repaired = this.repairInventory(player.getInventory().getArmorContents());
                this.sendSuccessMessage(commandSender, repaired);
                break;
            }
            case "inventory": {
                int repaired = this.repairInventory(player.getInventory().getContents());
                this.sendSuccessMessage(commandSender, repaired);
                break;
            }
            default: {
                MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            }
        }
    }

    private void sendSuccessMessage(User commandSender, int count) {
        MessageBuilder.command("Repair.Success", commandSender).postModifier(message -> message.replace("<COUNT>", String.valueOf(count))).build();
    }

    private boolean repairItem(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)meta;
        if (!damageable.hasDamage()) {
            return false;
        }
        damageable.setDamage(0);
        item.setItemMeta(meta);
        return true;
    }

    private int repairInventory(ItemStack[] items) {
        int repairedCount = 0;
        for (ItemStack item : items) {
            if (!this.repairItem(item)) continue;
            ++repairedCount;
        }
        return repairedCount;
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Repair";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Repair.Use", false);
    }
}

