/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.seen;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.seen.TabCompleterSeen;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="seen", tabCompleter=TabCompleterSeen.class)
public class CommandSeen
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Seen.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(arguments[0]);
        if (cachedUserOptional.isEmpty()) {
            ServerSystem.getLog().warning("(CommandSeen) User '" + arguments[0] + "' is not cached! This should not happen!");
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        OfflineUser targetUser = cachedUserOptional.get().getOfflineUser();
        if (targetUser.getName().isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        long lastSeen = targetUser.getLastSeen();
        if (targetUser instanceof User) {
            lastSeen = System.currentTimeMillis();
        }
        String formattedDate = this.parseDate(lastSeen);
        MessageBuilder.command("Seen.Success", commandSender).target(targetUser.getName().get()).postModifier(message -> message.replace("<DATE>", formattedDate).replace("<IP>", targetUser.getLastKnownIp())).build();
    }

    private String parseDate(long dateMillis) {
        return Instant.ofEpochMilli(dateMillis).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss"));
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Seen";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Seen.Use", false);
    }
}

