/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.serversystem;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import me.testaccount666.migration.plugins.MigratorRegistry;
import me.testaccount666.migration.plugins.PluginMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.serversystem.TabCompleterServerSystem;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.updates.UpdateManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@ServerSystemCommand(name="serversystem", tabCompleter=TabCompleterServerSystem.class)
public class CommandServerSystem
extends AbstractServerSystemCommand {
    @Override
    public String getSyntaxPath(Command command) {
        return "ServerSystem";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "ServerSystem.Use", false);
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String subCommand;
        if (!this.checkBasePermission(commandSender, "ServerSystem.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String[] newArguments = new String[arguments.length - 1];
        System.arraycopy(arguments, 1, newArguments, 0, arguments.length - 1);
        switch (subCommand = arguments[0].toLowerCase()) {
            case "version": {
                this.version(commandSender, label);
                break;
            }
            case "reload": {
                this.reload(commandSender);
                break;
            }
            case "migrate": {
                this.migrate(commandSender, label, newArguments);
                break;
            }
            default: {
                MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            }
        }
    }

    public void version(User commandSender, String label) {
        if (!this.checkBasePermission(commandSender, "ServerSystem.Version")) {
            return;
        }
        MessageBuilder.command("ServerSystem.Version.Checking", commandSender).build();
        UpdateManager updateManager = ServerSystem.Instance.getRegistry().getService(UpdateManager.class);
        ((CompletableFuture)updateManager.getUpdateChecker().getLatestVersion().thenAccept(latestVersion -> MessageBuilder.command("ServerSystem.Version.Success", commandSender).postModifier(message -> this.applyVersion((String)message, latestVersion.getVersion())).prefix(false).build())).exceptionally(throwable -> {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            MessageBuilder.command("ServerSystem.Version.Success", commandSender).postModifier(message -> this.applyVersion((String)message, null)).prefix(false).build();
            return null;
        });
    }

    private String applyVersion(String message, String latestVersion) {
        if (latestVersion == null) {
            latestVersion = "?";
        }
        String currentVersion = ServerSystem.Instance.getDescription().getVersion();
        String serverVersion = ServerSystem.getServerVersion().getVersion();
        return message.replace("<LATEST_VERSION>", latestVersion).replace("<CURRENT_VERSION>", currentVersion).replace("<SERVER_VERSION>", serverVersion);
    }

    public void reload(User commandSender) {
        if (!this.checkBasePermission(commandSender, "ServerSystem.Reload")) {
            return;
        }
        ServerSystem serverSystem = ServerSystem.Instance;
        Bukkit.getScheduler().cancelTasks((Plugin)serverSystem);
        serverSystem.onDisable();
        serverSystem.onEnable();
        if (!ServerSystem.Instance.isEnabled()) {
            MessageBuilder.general("ErrorOccurred", commandSender).build();
            return;
        }
        MessageBuilder.command("ServerSystem.Reload.Success", commandSender).build();
    }

    public void migrate(User commandSender, String label, String ... arguments) {
        String migrationType;
        String migratorName;
        if (!this.checkBasePermission(commandSender, "ServerSystem.Migrate")) {
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).label(label).syntax(this.getSyntaxPath(null)).build();
            return;
        }
        MigratorRegistry migratorRegistry = ServerSystem.Instance.getRegistry().getService(MigratorRegistry.class);
        Optional<PluginMigrator> migrator = migratorRegistry.getMigrator(migratorName = arguments[1]);
        if (migrator.isEmpty()) {
            MessageBuilder.command("ServerSystem.Migrate.NotFound", commandSender).postModifier(message -> message.replace("<MIGRATOR>", migratorName)).build();
            return;
        }
        switch (migrationType = arguments[0].toLowerCase()) {
            case "to": {
                migrator.get().migrateTo();
                migrationType = "To";
                break;
            }
            case "from": {
                migrator.get().migrateFrom();
                migrationType = "From";
                break;
            }
            default: {
                MessageBuilder.general("InvalidArguments", commandSender).label(label).syntax(this.getSyntaxPath(null)).build();
                return;
            }
        }
        MessageBuilder.command("ServerSystem.Migrate.Success." + migrationType, commandSender).postModifier(message -> message.replace("<MIGRATOR>", migratorName)).build();
    }
}

