/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.sign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@ServerSystemCommand(name="sign", variants={"unsign"})
public class CommandSign
extends AbstractServerSystemCommand {
    protected final NamespacedKey signKey = new NamespacedKey((Plugin)ServerSystem.Instance, "sign");

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, this.getCommandPermission(command))) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        Player player = commandSender.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.isEmpty()) {
            MessageBuilder.command("Sign.NoItemInHand", commandSender).build();
            return;
        }
        ItemMeta meta = itemInHand.getItemMeta();
        if (meta == null) {
            MessageBuilder.command("Sign.NoItemMeta", commandSender).build();
            return;
        }
        if (command.getName().equalsIgnoreCase("sign")) {
            this.executeSign(itemInHand, meta, commandSender, command, label, arguments);
        } else {
            this.executeUnsign(itemInHand, meta, commandSender);
        }
    }

    private void executeUnsign(ItemStack itemInHand, ItemMeta itemMeta, User commandSender) {
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (!dataContainer.has(this.signKey)) {
            MessageBuilder.command("Unsign.NotSigned", commandSender).build();
            return;
        }
        ArrayList<Component> lore = itemMeta.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        lore.removeIf(loreComponent -> {
            String strippedLine = ChatColor.stripColor(ComponentColor.componentToString(loreComponent));
            String strippedLore = ChatColor.stripColor((String)dataContainer.get(this.signKey, PersistentDataType.STRING));
            return Arrays.stream(strippedLore.split("\n")).anyMatch(strippedLine::equalsIgnoreCase);
        });
        itemMeta.lore(lore);
        dataContainer.remove(this.signKey);
        itemInHand.setItemMeta(itemMeta);
        MessageBuilder.command("Unsign.Success", commandSender).build();
    }

    private void executeSign(ItemStack itemInHand, ItemMeta itemMeta, User commandSender, Command command, String label, String ... arguments) {
        String message;
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (dataContainer.has(this.signKey)) {
            MessageBuilder.command("Sign.AlreadySigned", commandSender).build();
            return;
        }
        ArrayList<Component> lore = itemMeta.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        if ((message = String.join((CharSequence)" ", arguments).trim()).isEmpty()) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String parsedDate = DurationParser.parseDate(System.currentTimeMillis(), commandSender);
        Optional<String> loreMessage = MessageBuilder.command("Sign.Format", commandSender).prefix(false).send(false).postModifier(msg -> msg.replace("<MESSAGE>", message).replace("<DATE>", parsedDate)).build();
        if (loreMessage.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        dataContainer.set(this.signKey, PersistentDataType.STRING, (Object)loreMessage.get());
        for (String line : loreMessage.get().split("\n")) {
            Component lineComponent = ComponentColor.translateToComponent(line);
            lore.add(lineComponent);
        }
        itemMeta.lore(lore);
        itemInHand.setItemMeta(itemMeta);
        MessageBuilder.command("Sign.Success", commandSender).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return command.getName().equalsIgnoreCase("sign") ? "Sign" : "Unsign";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, this.getCommandPermission(command), false);
    }

    private String getCommandPermission(Command command) {
        return command.getName().equalsIgnoreCase("sign") ? "Sign.Use" : "Unsign.Use";
    }
}

