/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.signcost;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Set;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.cost.CostType;
import me.testaccount666.serversystem.clickablesigns.util.SignUtils;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.signcost.TabCompleterSignCost;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="signcost", tabCompleter=TabCompleterSignCost.class)
public class CommandSignCost
extends AbstractServerSystemCommand {
    private static final Set<String> _COST_TYPES = Set.of("none", "exp", "economy");
    private static final int _MAX_DISTANCE = 5;

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        Player player;
        Block targetBlock;
        BlockState blockState;
        CostType costType;
        if (!this.checkBasePermission(commandSender, "SignCost.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length < 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String costTypeStr = arguments[0].toLowerCase();
        if (!_COST_TYPES.contains(costTypeStr)) {
            MessageBuilder.sign("Cost.InvalidType", commandSender).postModifier(message -> message.replace("<TYPES>", String.join((CharSequence)", ", _COST_TYPES))).build();
            return;
        }
        try {
            costType = CostType.valueOf(costTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            MessageBuilder.sign("Cost.InvalidType", commandSender).postModifier(message -> message.replace("<TYPES>", String.join((CharSequence)", ", _COST_TYPES))).build();
            return;
        }
        double amount = 0.0;
        if (costType != CostType.NONE) {
            if (arguments.length < 2) {
                MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
                return;
            }
            try {
                amount = Double.parseDouble(arguments[1]);
                if (amount <= 0.0) {
                    MessageBuilder.sign("Cost.InvalidAmount", commandSender).build();
                    return;
                }
            }
            catch (NumberFormatException ignored) {
                MessageBuilder.sign("Cost.InvalidAmount", commandSender).build();
                return;
            }
        }
        if (!((blockState = (targetBlock = (player = commandSender.getPlayer()).getTargetBlock(null, 5)).getState()) instanceof Sign)) {
            MessageBuilder.command("ClickableSigns.Cost.NotLookingAtSign", commandSender).build();
            return;
        }
        Sign sign = (Sign)blockState;
        File signFile = SignUtils.getSignFile(sign.getLocation());
        if (!signFile.exists()) {
            MessageBuilder.sign("Cost.NotClickableSign", commandSender).build();
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)signFile);
        if (!config.contains("Key")) {
            MessageBuilder.sign("Cost.NotClickableSign", commandSender).build();
            return;
        }
        config.set("Cost.Type", (Object)costType.name());
        config.set("Cost.Amount", (Object)amount);
        try {
            config.save(signFile);
        }
        catch (IOException exception) {
            MessageBuilder.general("ErrorOccurred", commandSender).build();
            ServerSystem.getLog().log(Level.SEVERE, "Error occurred while saving sign cost config '" + signFile.getAbsolutePath() + "'", exception);
            return;
        }
        if (costType == CostType.NONE) {
            sign.setLine(3, "");
            sign.update();
            MessageBuilder.command("ClickableSigns.Cost.SetNone", commandSender).build();
            return;
        }
        Object costLine = costType == CostType.EXP ? (int)amount + " EXP" : ServerSystem.Instance.getRegistry().getService(EconomyProvider.class).formatMoney(BigDecimal.valueOf(amount));
        sign.getSide(Side.FRONT).line(3, ComponentColor.translateToComponent("&6" + (String)costLine));
        sign.getSide(Side.BACK).line(3, ComponentColor.translateToComponent("&6" + (String)costLine));
        sign.update();
        double finalAmount = amount;
        MessageBuilder.sign("Cost.Set", commandSender).postModifier(message -> message.replace("<TYPE>", costType.name()).replace("<AMOUNT>", String.valueOf(finalAmount))).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "SignCost";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "SignCost.Use", false);
    }
}

