/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.spawn;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.spawn.CommandSpawn;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

@RequiredCommands(requiredCommands={CommandSpawn.class})
public class ListenerSpawn
implements Listener {
    private CommandSpawn _commandSpawn;

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandSpawn)) {
                return;
            }
            CommandSpawn commandSpawn = (CommandSpawn)command;
            this._commandSpawn = commandSpawn;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPlayedBefore() ? !this._commandSpawn.teleportOnJoin : !this._commandSpawn.teleportOnFirstJoin) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> {
            Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(player);
            if (userOptional.isEmpty()) {
                return;
            }
            CachedUser cachedUser = userOptional.get();
            if (cachedUser.isOfflineUser()) {
                return;
            }
            User user = (User)cachedUser.getOfflineUser();
            this._commandSpawn.handleSpawnCommand(user, "spawn", new String[0]);
        }, 20L);
    }
}

