/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.speed;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="speed", variants={"flyspeed", "walkspeed"})
public class CommandSpeed
extends AbstractServerSystemCommand {
    private static SpeedResult calculateSpeeds(float speed) {
        if (speed <= 0.0f) {
            return new SpeedResult(0.0f, 0.0f);
        }
        float flySpeed = speed / 10.0f;
        flySpeed = Math.clamp(flySpeed, 0.0f, 1.0f);
        float walkSpeed = 0.2f + (speed - 1.0f) * 0.0888889f;
        walkSpeed = Math.clamp(walkSpeed, 0.0f, 1.0f);
        return new SpeedResult(walkSpeed, flySpeed);
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        Float speed;
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Speed.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, 1, arguments)) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, 1, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Speed.Other", targetPlayer.getName())) {
            return;
        }
        String speedType = switch (command.getName().toLowerCase()) {
            case "flyspeed" -> "Fly";
            case "walkspeed" -> "Walk";
            default -> targetPlayer.isFlying() ? "Fly" : "Walk";
        };
        try {
            speed = Float.valueOf(Float.parseFloat(arguments[0]));
            speed = Float.valueOf(Math.max(0.0f, speed.floatValue()));
            speed = Float.valueOf(Math.min(10.0f, speed.floatValue()));
        }
        catch (NumberFormatException ignored) {
            MessageBuilder.command("Speed.InvalidSpeed", commandSender).target(targetPlayer.getName()).build();
            return;
        }
        SpeedResult speedTuple = CommandSpeed.calculateSpeeds(speed.floatValue());
        speed = switch (speedType) {
            case "Fly" -> Float.valueOf(speedTuple.flySpeed());
            case "Walk" -> Float.valueOf(speedTuple.walkSpeed());
            default -> throw new IllegalStateException("Unexpected value: " + speedType);
        };
        if (speedType.equalsIgnoreCase("Fly")) {
            targetPlayer.setFlySpeed(speed.floatValue());
        } else {
            targetPlayer.setWalkSpeed(speed.floatValue());
        }
        String messagePath = isSelf ? "Speed.Success" : "Speed.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<SPEED>", arguments[0])).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Speed.Success", targetUser).target(targetPlayer.getName()).sender(commandSender.getName().get()).postModifier(message -> message.replace("<SPEED>", arguments[0])).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Speed";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Speed.Use", false);
    }

    private record SpeedResult(float walkSpeed, float flySpeed) {
    }
}

