/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.teamchat;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="teamchat")
public class CommandTeamChat
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "TeamChat.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String message = String.join((CharSequence)" ", arguments).trim();
        Optional<String> formatOptional = MessageBuilder.command("TeamChat.Format", commandSender).send(false).prefix(false).postModifier(format -> format.replace("<MESSAGE>", message)).build();
        if (formatOptional.isEmpty()) {
            return;
        }
        String format2 = formatOptional.get();
        Bukkit.getOnlinePlayers().forEach(everyone -> {
            if (!PermissionManager.hasCommandPermission((CommandSender)everyone, "TeamChat.Use", false)) {
                return;
            }
            everyone.sendMessage(format2);
        });
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "TeamChat";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "TeamChat.Use", false);
    }
}

