/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.teleportask;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.teleportask.TeleportRequest;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@ServerSystemCommand(name="teleportask", variants={"teleporthereask", "teleportaccept", "teleportdeny", "teleporttoggle"})
public class CommandTeleportAsk
extends AbstractServerSystemCommand {
    protected final Set<TeleportRequest> activeTeleportRequests = new HashSet<TeleportRequest>();

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        switch (command.getName()) {
            case "teleportask": {
                this.handleTeleportAsk(commandSender, label, arguments);
                break;
            }
            case "teleportaccept": {
                this.handleTeleportAccept(commandSender, label);
                break;
            }
            case "teleportdeny": {
                this.handleTeleportDeny(commandSender, label);
                break;
            }
            case "teleporthereask": {
                this.handleTeleportHereAsk(commandSender, label, arguments);
                break;
            }
            case "teleporttoggle": {
                this.handleTeleportToggle(commandSender, command, label, arguments);
            }
        }
    }

    private User validateTargetPlayer(User commandSender, String label, String ... arguments) {
        boolean isSelf;
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return null;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (isSelf) {
            MessageBuilder.command("TeleportAsk.CannotTeleportSelf", commandSender).build();
            return null;
        }
        if (!targetUser.isAcceptsTeleports()) {
            MessageBuilder.command("TeleportAsk.NoTeleport", commandSender).target(targetPlayer.getName()).build();
            return null;
        }
        return targetUser;
    }

    private boolean validateTeleportCommand(User commandSender, String permissionSuffix, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, permissionSuffix)) {
            return true;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return true;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(null)).label(label).build();
            return true;
        }
        return false;
    }

    private void handleTeleportAsk(User commandSender, String label, String ... arguments) {
        if (this.validateTeleportCommand(commandSender, "TeleportAsk.Use", label, arguments)) {
            return;
        }
        User targetUser = this.validateTargetPlayer(commandSender, label, arguments);
        if (targetUser == null) {
            return;
        }
        Player targetPlayer = targetUser.getPlayer();
        long timeOut = System.currentTimeMillis() + 120000L;
        MessageBuilder.command("TeleportAsk.Success", commandSender).target(targetPlayer.getName()).build();
        if (targetUser.isIgnoredPlayer(commandSender.getUuid())) {
            return;
        }
        MessageBuilder.command("TeleportAsk.SuccessOther", targetUser).sender(commandSender.getName().get()).build();
        TeleportRequest teleportRequest = new TeleportRequest(commandSender, targetUser, timeOut, false);
        targetUser.setTeleportRequest(teleportRequest);
        this.sendAcceptDenyButtons(commandSender, targetUser, label);
    }

    private void handleTeleportHereAsk(User commandSender, String label, String ... arguments) {
        if (this.validateTeleportCommand(commandSender, "TeleportHereAsk.Use", label, arguments)) {
            return;
        }
        User targetUser = this.validateTargetPlayer(commandSender, label, arguments);
        if (targetUser == null) {
            return;
        }
        Player targetPlayer = targetUser.getPlayer();
        long timeOut = System.currentTimeMillis() + 120000L;
        MessageBuilder.command("TeleportHereAsk.Success", commandSender).target(targetPlayer.getName()).build();
        if (targetUser.isIgnoredPlayer(commandSender.getUuid())) {
            return;
        }
        MessageBuilder.command("TeleportHereAsk.SuccessOther", targetUser).sender(commandSender.getName().get()).build();
        TeleportRequest teleportRequest = new TeleportRequest(commandSender, targetUser, timeOut, true);
        targetUser.setTeleportRequest(teleportRequest);
        this.sendAcceptDenyButtons(commandSender, targetUser, label);
    }

    private void sendAcceptDenyButtons(User commandSender, User targetUser, String label) {
        Player targetPlayer = targetUser.getPlayer();
        Optional<String> acceptButton = MessageBuilder.command("TeleportAsk.Buttons.Accept.Name", targetUser).postModifier(message -> MessageManager.applyPlaceholders(message, commandSender, targetPlayer.getName(), label)).format(false).send(false).prefix(false).build();
        Optional<String> denyButton = MessageBuilder.command("TeleportAsk.Buttons.Deny.Name", targetUser).postModifier(message -> MessageManager.applyPlaceholders(message, commandSender, targetPlayer.getName(), label)).format(false).send(false).prefix(false).build();
        if (acceptButton.isEmpty() || denyButton.isEmpty()) {
            ServerSystem.getLog().warning("Couldn't find accept or deny button for " + targetUser.getName().get() + " in the language file. Please check the language file for errors.");
            MessageBuilder.general("ErrorOccurred", targetUser).label(label).build();
            return;
        }
        Optional<String> acceptButtonTooltip = MessageBuilder.command("TeleportAsk.Buttons.Accept.Tooltip", targetUser).postModifier(message -> MessageManager.applyPlaceholders(message, commandSender, targetPlayer.getName(), label)).format(false).prefix(false).send(false).build();
        Optional<String> denyButtonTooltip = MessageBuilder.command("TeleportAsk.Buttons.Deny.Tooltip", targetUser).postModifier(message -> MessageManager.applyPlaceholders(message, commandSender, targetPlayer.getName(), label)).format(false).prefix(false).send(false).build();
        if (acceptButtonTooltip.isEmpty() || denyButtonTooltip.isEmpty()) {
            ServerSystem.getLog().warning("Couldn't find accept or deny button tooltip for " + targetUser.getName().get() + " in the language file. Please check the language file for errors.");
            MessageBuilder.general("ErrorOccurred", targetUser).label(label).build();
            return;
        }
        Component acceptComponent = this.createMessageComponent(acceptButton.get(), acceptButtonTooltip.get(), ClickEvent.callback(audience -> this.handleTeleportAccept(targetUser, label)));
        Component denyComponent = this.createMessageComponent(denyButton.get(), denyButtonTooltip.get(), ClickEvent.callback(audience -> this.handleTeleportDeny(targetUser, label)));
        targetPlayer.sendMessage(acceptComponent);
        targetPlayer.sendMessage(denyComponent);
    }

    private TeleportRequest validateTeleportRequest(User commandSender, String permissionSuffix) {
        if (!this.checkBasePermission(commandSender, permissionSuffix)) {
            return null;
        }
        TeleportRequest teleportRequest = commandSender.getTeleportRequest();
        if (teleportRequest == null || teleportRequest.isExpired()) {
            MessageBuilder.command("TeleportAccept.NoRequest", commandSender).build();
            return null;
        }
        User requester = teleportRequest.getSender();
        if (requester.getPlayer() == null || !requester.getPlayer().isOnline()) {
            MessageBuilder.command("TeleportAccept.NoRequest", commandSender).build();
            return null;
        }
        return teleportRequest;
    }

    private void handleTeleportAccept(User commandSender, String label) {
        TeleportRequest teleportRequest = this.validateTeleportRequest(commandSender, "TeleportAccept.Use");
        if (teleportRequest == null) {
            return;
        }
        User requester = teleportRequest.getSender();
        commandSender.setTeleportRequest(null);
        MessageBuilder.command("TeleportAccept.SuccessOther", requester).target(commandSender.getName().get()).build();
        User teleporter = teleportRequest.isTeleportHere() ? commandSender : requester;
        User target = teleportRequest.isTeleportHere() ? requester : commandSender;
        boolean canInstantTeleport = PermissionManager.hasCommandPermission(teleporter, "TeleportAsk.InstantTeleport", false);
        if (canInstantTeleport) {
            this.executeTeleport(teleporter, target, label);
            return;
        }
        MessageBuilder.command("TeleportAsk.StartingTeleporting", teleporter).target(target.getName().get()).build();
        this.startTeleportTimer(teleporter, target, teleportRequest);
    }

    private void handleTeleportDeny(User commandSender, String label) {
        TeleportRequest teleportRequest = this.validateTeleportRequest(commandSender, "TeleportDeny.Use");
        if (teleportRequest == null) {
            return;
        }
        User requester = teleportRequest.getSender();
        commandSender.setTeleportRequest(null);
        MessageBuilder.command("TeleportDeny.Success", commandSender).target(requester.getName().get()).build();
        MessageBuilder.command("TeleportDeny.SuccessOther", requester).target(commandSender.getName().get()).build();
    }

    private void startTeleportTimer(User teleporter, User target, TeleportRequest teleportRequest) {
        Player teleporterPlayer = teleporter.getPlayer();
        Player targetPlayer = target.getPlayer();
        this.activeTeleportRequests.add(teleportRequest);
        teleportRequest.setTimerId(Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ServerSystem.Instance, () -> {
            if (teleporterPlayer == null || !teleporterPlayer.isOnline()) {
                return;
            }
            if (targetPlayer == null || !targetPlayer.isOnline()) {
                return;
            }
            this.executeTeleport(teleporter, target, null);
            this.activeTeleportRequests.remove(teleportRequest);
        }, 100L));
    }

    private void executeTeleport(User teleporter, User target, String label) {
        Location targetLocation = target.getPlayer().getLocation();
        this.playAnimation(targetLocation);
        teleporter.getPlayer().teleport(targetLocation);
        this.playAnimation(targetLocation);
        MessageBuilder.command("TeleportAsk.TeleportFinished", teleporter).target(target.getName().get()).build();
    }

    private Component createMessageComponent(String text, String hoverText, ClickEvent clickAction) {
        if (text == null || hoverText == null || clickAction == null) {
            return Component.empty();
        }
        return ComponentColor.translateToComponent(text).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ComponentColor.translateToComponent(hoverText))).clickEvent(clickAction).asComponent();
    }

    private void playAnimation(Location location) {
        location.getWorld().playSound(location, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        location.getWorld().spawnParticle(Particle.PORTAL, location, 100, 0.5, 0.5, 0.5, 0.05);
    }

    private void handleTeleportToggle(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "TeleportToggle.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "TeleportToggle.Other", targetPlayer.getName())) {
            return;
        }
        boolean acceptsTeleports = !targetUser.isAcceptsTeleports();
        Object messagePath = isSelf ? "TeleportToggle.Success" : "TeleportToggle.SuccessOther";
        messagePath = acceptsTeleports ? (String)messagePath + ".Enabled" : (String)messagePath + ".Disabled";
        targetUser.setAcceptsTeleports(acceptsTeleports);
        targetUser.save();
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("TeleportToggle.Success" + (acceptsTeleports ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        if (command != null && command.getName().equalsIgnoreCase("teleporttoggle")) {
            return "TeleportToggle";
        }
        return "TeleportAsk";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath;
        switch (command.getName()) {
            case "teleportask": {
                String string = "TeleportAsk.Use";
                break;
            }
            case "teleportaccept": {
                String string = "TeleportAccept.Use";
                break;
            }
            case "teleportdeny": {
                String string = "TeleportDeny.Use";
                break;
            }
            case "teleporthereask": {
                String string = "TeleportHereAsk.Use";
                break;
            }
            case "teleporttoggle": {
                String string = "TeleportToggle.Use";
                break;
            }
            default: {
                String string = permissionPath = null;
            }
        }
        if (permissionPath == null) {
            return false;
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }
}

