/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.teleportask;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.teleportask.CommandTeleportAsk;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

@RequiredCommands(requiredCommands={CommandTeleportAsk.class})
public class ListenerTeleportRequest
implements Listener {
    private CommandTeleportAsk _commandTeleportAsk;

    private static double getDistance(PlayerMoveEvent event) {
        double fromX = event.getFrom().getX();
        double toX = event.getTo().getX();
        double fromY = event.getFrom().getY();
        double toY = event.getTo().getY();
        double fromZ = event.getFrom().getZ();
        double toZ = event.getTo().getZ();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        Location from = new Location(fromWorld, fromX, fromY, fromZ);
        Location to = new Location(toWorld, toX, toY, toZ);
        return from.getWorld().getName().equalsIgnoreCase(to.getWorld().getName()) ? from.distance(to) : Double.MAX_VALUE;
    }

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandTeleportAsk)) {
                return;
            }
            CommandTeleportAsk commandTeleportAsk = (CommandTeleportAsk)command;
            this._commandTeleportAsk = commandTeleportAsk;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onTeleporterMove(PlayerMoveEvent event) {
        double distance = ListenerTeleportRequest.getDistance(event);
        if (distance < 0.1) {
            return;
        }
        Collections.unmodifiableSet(this._commandTeleportAsk.activeTeleportRequests).forEach(teleportRequest -> {
            User teleporter;
            User user = teleporter = teleportRequest.isTeleportHere() ? teleportRequest.getReceiver() : teleportRequest.getSender();
            if (teleporter.getPlayer() == null) {
                return;
            }
            Player teleporterPlayer = teleporter.getPlayer();
            if (!event.getPlayer().getUniqueId().equals(teleporterPlayer.getUniqueId())) {
                return;
            }
            Bukkit.getScheduler().cancelTask(teleportRequest.getTimerId());
            teleportRequest.setCancelled(true);
            this._commandTeleportAsk.activeTeleportRequests.remove(teleportRequest);
            MessageBuilder.command("TeleportAsk.Moved", teleporter).build();
        });
    }
}

