/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.time;

import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.time.TabCompleterTime;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="time", variants={"day", "night", "noon", "midnight"}, tabCompleter=TabCompleterTime.class)
public class CommandTime
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        World world;
        if (command.getName().equalsIgnoreCase("time")) {
            this.handleTimeCommand(commandSender, command, label, arguments);
            return;
        }
        if (commandSender instanceof ConsoleUser && arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (arguments.length >= 1) {
            if (!this.checkBasePermission(commandSender, "Time.World")) {
                return;
            }
            world = Bukkit.getWorld((String)arguments[0]);
        } else {
            world = commandSender.getPlayer().getWorld();
        }
        if (world == null) {
            MessageBuilder.command("Time.WorldNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        this.handleTimeCommand(commandSender, command, label, command.getName(), world.getName());
    }

    private void handleTimeCommand(User commandSender, Command command, String label, String ... arguments) {
        World world;
        if (!this.checkBasePermission(commandSender, "Time.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (commandSender instanceof ConsoleUser && arguments.length == 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (arguments.length >= 2) {
            if (!this.checkBasePermission(commandSender, "Time.World")) {
                return;
            }
            world = Bukkit.getWorld((String)arguments[1]);
        } else {
            world = commandSender.getPlayer().getWorld();
        }
        if (world == null) {
            MessageBuilder.command("Time.WorldNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        switch (arguments[0].toLowerCase()) {
            case "day": {
                world.setTime(0L);
                break;
            }
            case "night": {
                world.setTime(13000L);
                break;
            }
            case "noon": {
                world.setTime(6000L);
                break;
            }
            case "midnight": {
                world.setTime(18000L);
                break;
            }
            default: {
                try {
                    long time = Long.parseLong(arguments[0]);
                    world.setTime(time *= 20L);
                    break;
                }
                catch (NumberFormatException ignored) {
                    MessageBuilder.general("InvalidArguments", commandSender).syntax(this.getSyntaxPath(command)).label(label).build();
                    return;
                }
            }
        }
        MessageBuilder.command("Time.Success", commandSender).target(world.getName()).postModifier(message -> message.replace("<TIME>", arguments[0]).replace("<WORLD>", world.getName())).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "time" -> "Time";
            case "day" -> "Day";
            case "night" -> "Night";
            case "noon" -> "Noon";
            case "midnight" -> "Midnight";
            default -> throw new IllegalStateException("(CommandTime) Unexpected value: " + commandName);
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Time.Use", false);
    }
}

