/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.unlimited;

import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@ServerSystemCommand(name="unlimited")
public class CommandUnlimited
extends AbstractServerSystemCommand {
    protected final NamespacedKey unlimitedKey = new NamespacedKey((Plugin)ServerSystem.Instance, "unlimited");

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean setUnlimited;
        if (!this.checkBasePermission(commandSender, "Unlimited.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        ItemStack itemInHand = commandSender.getPlayer().getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            MessageBuilder.command("Unlimited.NoItemInHand", commandSender).build();
            return;
        }
        ItemMeta itemMeta = itemInHand.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        boolean bl = setUnlimited = !dataContainer.has(this.unlimitedKey, PersistentDataType.BYTE);
        if (setUnlimited) {
            dataContainer.set(this.unlimitedKey, PersistentDataType.BYTE, (Object)1);
        } else {
            dataContainer.remove(this.unlimitedKey);
        }
        itemInHand.setItemMeta(itemMeta);
        String messagePath = setUnlimited ? "Unlimited.Success.Enabled" : "Unlimited.Success.Disabled";
        MessageBuilder.command(messagePath, commandSender).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        throw new UnsupportedOperationException("Unlimited command doesn't have an available syntax!");
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Unlimited.Use", false);
    }
}

