/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.unlimited;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.unlimited.CommandUnlimited;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TropicalFish;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

@RequiredCommands(requiredCommands={CommandUnlimited.class})
public class ListenerUnlimited
implements Listener {
    private CommandUnlimited _commandUnlimited;

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandUnlimited)) {
                return;
            }
            CommandUnlimited commandUnlimited = (CommandUnlimited)command;
            this._commandUnlimited = commandUnlimited;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent event) {
        ItemStack itemInHand = event.getItem();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        event.setReplacement(itemInHand);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack itemInHand = event.getItemInHand();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        itemInHand.setAmount(itemInHand.getAmount() + 1);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        ItemStack itemInHand = event.getItemDrop().getItemStack();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        event.setCancelled(true);
        Item newItem = event.getItemDrop().getWorld().dropItemNaturally(event.getItemDrop().getLocation(), itemInHand);
        ItemStack newItemStack = newItem.getItemStack();
        ItemMeta newItemMeta = newItemStack.getItemMeta();
        PersistentDataContainer newDataContainer = newItemMeta.getPersistentDataContainer();
        newDataContainer.remove(this._commandUnlimited.unlimitedKey);
        newItemStack.setItemMeta(newItemMeta);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        ItemStack itemInHand = event.getPlayer().getInventory().getItem(event.getHand());
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        event.setCancelled(true);
        this.handleBucketEmpty(event);
    }

    private void handleBucketEmpty(PlayerBucketEmptyEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation().add(0.5, 0.5, 0.5);
        switch (event.getBucket()) {
            case WATER_BUCKET: {
                location.getWorld().setType(location, Material.WATER);
                break;
            }
            case LAVA_BUCKET: {
                location.getWorld().setType(location, Material.LAVA);
                break;
            }
            case POWDER_SNOW_BUCKET: {
                location.getWorld().setType(location, Material.POWDER_SNOW);
                break;
            }
            case AXOLOTL_BUCKET: 
            case COD_BUCKET: 
            case SALMON_BUCKET: 
            case TADPOLE_BUCKET: 
            case PUFFERFISH_BUCKET: 
            case TROPICAL_FISH_BUCKET: {
                this.handleAquaticBucketEmpty(event, location);
            }
        }
    }

    private void handleAquaticBucketEmpty(PlayerBucketEmptyEvent event, Location location) {
        location.getWorld().setType(location, Material.WATER);
        ItemStack itemInHand = event.getPlayer().getInventory().getItem(event.getHand());
        ItemMeta itemMeta = itemInHand.getItemMeta();
        switch (event.getBucket()) {
            case AXOLOTL_BUCKET: {
                location.getWorld().spawn(location, Axolotl.class, CreatureSpawnEvent.SpawnReason.BUCKET, axolotl -> this.handleEntitySpawn((Entity)axolotl, itemMeta));
                break;
            }
            case COD_BUCKET: {
                location.getWorld().spawn(location, Cod.class, CreatureSpawnEvent.SpawnReason.BUCKET, cod -> this.handleEntitySpawn((Entity)cod, itemMeta));
                break;
            }
            case SALMON_BUCKET: {
                location.getWorld().spawn(location, Salmon.class, CreatureSpawnEvent.SpawnReason.BUCKET, salmon -> this.handleEntitySpawn((Entity)salmon, itemMeta));
                break;
            }
            case TADPOLE_BUCKET: {
                location.getWorld().spawn(location, Tadpole.class, CreatureSpawnEvent.SpawnReason.BUCKET, tadpole -> this.handleEntitySpawn((Entity)tadpole, itemMeta));
                break;
            }
            case PUFFERFISH_BUCKET: {
                location.getWorld().spawn(location, PufferFish.class, CreatureSpawnEvent.SpawnReason.BUCKET, pufferfish -> this.handleEntitySpawn((Entity)pufferfish, itemMeta));
                break;
            }
            case TROPICAL_FISH_BUCKET: {
                location.getWorld().spawn(location, TropicalFish.class, CreatureSpawnEvent.SpawnReason.BUCKET, tropicalfish -> this.handleEntitySpawn((Entity)tropicalfish, itemMeta));
            }
        }
    }

    private void handleEntitySpawn(Entity entity, ItemMeta itemMeta) {
        TropicalFishBucketMeta bucketMeta;
        if (itemMeta instanceof TropicalFishBucketMeta) {
            bucketMeta = (TropicalFishBucketMeta)itemMeta;
            if (entity instanceof TropicalFish) {
                TropicalFish tropicalFish = (TropicalFish)entity;
                if (bucketMeta.hasVariant()) {
                    tropicalFish.setPattern(bucketMeta.getPattern());
                    tropicalFish.setBodyColor(bucketMeta.getBodyColor());
                    tropicalFish.setPatternColor(bucketMeta.getPatternColor());
                }
            }
        }
        if (itemMeta instanceof AxolotlBucketMeta) {
            bucketMeta = (AxolotlBucketMeta)itemMeta;
            if (entity instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)entity;
                if (bucketMeta.hasVariant()) {
                    axolotl.setVariant(bucketMeta.getVariant());
                }
            }
        }
        if (itemMeta.hasCustomName()) {
            entity.customName(itemMeta.customName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent event) {
        ItemStack itemInHand = event.getPlayer().getInventory().getItem(event.getHand());
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        event.setCancelled(true);
        Block block = event.getBlock();
        Location location = block.getLocation();
        location.getWorld().setType(location, Material.AIR);
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        ItemStack itemInHand = event.getItem();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onDispenserFire(BlockDispenseEvent event) {
        ItemStack itemInHand = event.getItem();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        Block dispenserBlock = event.getBlock();
        BlockState blockState = dispenserBlock.getState();
        if (!(blockState instanceof Container)) {
            return;
        }
        Container container = (Container)blockState;
        BlockData blockData = dispenserBlock.getBlockData();
        if (!(blockData instanceof Directional)) {
            return;
        }
        Directional directional = (Directional)blockData;
        Vector velocity = event.getVelocity();
        BlockFace facing = directional.getFacing();
        Block facingBlock = dispenserBlock.getRelative(facing);
        int facingX = facingBlock.getX();
        int facingY = facingBlock.getY();
        int facingZ = facingBlock.getZ();
        double velocityX = velocity.getX();
        double velocityY = velocity.getY();
        double velocityZ = velocity.getZ();
        if ((double)facingX != velocityX || (double)facingY != velocityY || (double)facingZ != velocityZ) {
            Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> container.getInventory().addItem(new ItemStack[]{itemInHand}), 1L);
            return;
        }
        int foundIndex = this.findSimilarItemIndex(itemInHand, (InventoryHolder)container);
        if (foundIndex == -1) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> container.getInventory().setItem(foundIndex, itemInHand), 1L);
    }

    private int findSimilarItemIndex(ItemStack comparingItem, InventoryHolder inventoryHolder) {
        int foundIndex = -1;
        int maxIndex = inventoryHolder.getInventory().getSize();
        for (int index = 0; index < maxIndex; ++index) {
            ItemStack itemStack = inventoryHolder.getInventory().getItem(index);
            if (itemStack == null || !itemStack.isSimilar(comparingItem)) continue;
            foundIndex = index;
        }
        return foundIndex;
    }

    @EventHandler
    public void onDispenserArmorFire(BlockDispenseArmorEvent event) {
        ItemStack itemInHand = event.getItem();
        if (!this.isUnlimited(itemInHand)) {
            return;
        }
        ItemStack newItemStack = itemInHand.clone();
        ItemMeta newItemMeta = newItemStack.getItemMeta();
        PersistentDataContainer newDataContainer = newItemMeta.getPersistentDataContainer();
        newDataContainer.remove(this._commandUnlimited.unlimitedKey);
        newItemStack.setItemMeta(newItemMeta);
        event.setItem(newItemStack);
    }

    private boolean isUnlimited(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        return dataContainer.has(this._commandUnlimited.unlimitedKey);
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        ItemStack itemStack = event.getEntity().getItemStack();
        if (!this.isUnlimited(itemStack)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        dataContainer.remove(this._commandUnlimited.unlimitedKey);
        itemStack.setItemMeta(itemMeta);
        event.getEntity().setItemStack(itemStack);
    }
}

