/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.vanish;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.vanish.VanishPacket;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ServerSystemCommand(name="vanish", variants={"drop", "pickup", "interact", "message"})
public class CommandVanish
extends AbstractServerSystemCommand {
    protected final VanishPacket vanishPacket = new VanishPacket();

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Vanish.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        boolean isSelf = targetUser == commandSender;
        switch (command.getName().toLowerCase()) {
            case "vanish": {
                this.handleVanishCommand(commandSender, targetUser, isSelf);
                break;
            }
            case "drop": {
                this.handleDropCommand(commandSender, targetUser, isSelf);
                break;
            }
            case "pickup": {
                this.handlePickupCommand(commandSender, targetUser, isSelf);
                break;
            }
            case "interact": {
                this.handleInteractCommand(commandSender, targetUser, isSelf);
                break;
            }
            case "message": {
                this.handleMessageCommand(commandSender, targetUser, isSelf);
            }
        }
    }

    private void handleDropCommand(User commandSender, User targetUser, boolean isSelf) {
        this.handleToggleCommand(commandSender, targetUser, isSelf, "Drop", targetUser.getVanishData()::canDrop, value -> targetUser.getVanishData().canDrop((boolean)value));
    }

    private void handlePickupCommand(User commandSender, User targetUser, boolean isSelf) {
        this.handleToggleCommand(commandSender, targetUser, isSelf, "Pickup", targetUser.getVanishData()::canPickup, value -> targetUser.getVanishData().canPickup((boolean)value));
    }

    private void handleToggleCommand(User commandSender, User targetUser, boolean isSelf, String featureName, BooleanSupplier getCurrentState, Consumer<Boolean> setState) {
        String messagePath = isSelf ? featureName + ".Success" : featureName + ".SuccessOther";
        boolean enableFeature = !getCurrentState.getAsBoolean();
        messagePath = enableFeature ? messagePath + ".Enabled" : messagePath + ".Disabled";
        setState.accept(enableFeature);
        targetUser.save();
        MessageBuilder.command(messagePath, commandSender).target(targetUser.getName().get()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command(featureName + ".Success" + (enableFeature ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).build();
    }

    private void handleInteractCommand(User commandSender, User targetUser, boolean isSelf) {
        this.handleToggleCommand(commandSender, targetUser, isSelf, "Interact", targetUser.getVanishData()::canInteract, value -> targetUser.getVanishData().canInteract((boolean)value));
    }

    private void handleMessageCommand(User commandSender, User targetUser, boolean isSelf) {
        this.handleToggleCommand(commandSender, targetUser, isSelf, "Message", targetUser.getVanishData()::canMessage, value -> targetUser.getVanishData().canMessage((boolean)value));
    }

    private void handleVanishCommand(User commandSender, User targetUser, boolean isSelf) {
        Object messagePath = isSelf ? "Vanish.Success" : "Vanish.SuccessOther";
        boolean enableVanish = !targetUser.isVanish();
        messagePath = enableVanish ? (String)messagePath + ".Enabled" : (String)messagePath + ".Disabled";
        targetUser.getPlayer().setSleepingIgnored(enableVanish);
        targetUser.getPlayer().setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)ServerSystem.Instance, (Object)enableVanish));
        targetUser.setVanish(enableVanish);
        targetUser.save();
        this.vanishPacket.sendVanishPacket(targetUser);
        MessageBuilder.command((String)messagePath, commandSender).target(targetUser.getName().get()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Vanish.Success" + (enableVanish ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Vanish";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Vanish.Use", false);
    }
}

