/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.warp.manager;

import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Location;

public class Warp {
    private static final Pattern _WARP_NAME_PATTERN = Pattern.compile("[A-Za-z0-9_]+");
    private final String _name;
    private final Location _location;
    private String _displayName;

    Warp(String name, Location location) {
        if (!_WARP_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Warp name must be alphanumeric");
        }
        this._name = name.toLowerCase();
        this._location = location;
    }

    public static Optional<Warp> of(String name, Location location) {
        if (!_WARP_NAME_PATTERN.matcher(name).matches()) {
            return Optional.empty();
        }
        return Optional.of(new Warp(name, location));
    }

    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        this._displayName = this.getName().toLowerCase();
        char[] chars = this._displayName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        this._displayName = new String(chars);
        return this._displayName;
    }

    @Generated
    public String getName() {
        return this._name;
    }

    @Generated
    public Location getLocation() {
        return this._location;
    }
}

